/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import java.util.ArrayList;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;

public class LdifChangeAddRecord
extends LdifChangeRecord {
    private static final long serialVersionUID = -8976783000053951136L;

    protected LdifChangeAddRecord() {
    }

    public LdifChangeAddRecord(LdifDnLine dn) {
        super(dn);
    }

    public void addAttrVal(LdifAttrValLine attrVal) {
        if (attrVal == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.parts.add(attrVal);
    }

    public LdifAttrValLine[] getAttrVals() {
        ArrayList l = new ArrayList();
        for (Object o : this.parts) {
            if (!(o instanceof LdifAttrValLine)) continue;
            l.add(o);
        }
        return l.toArray(new LdifAttrValLine[l.size()]);
    }

    public static LdifChangeAddRecord create(String dn) {
        LdifChangeAddRecord record = new LdifChangeAddRecord(LdifDnLine.create(dn));
        record.setChangeType(LdifChangeTypeLine.createAdd());
        return record;
    }

    public boolean isValid() {
        if (!super.isAbstractValid()) {
            return false;
        }
        return this.getAttrVals().length > 0;
    }
}

