/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.studio.apacheds.model.Messages;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.model.ServerVersion;
import org.apache.directory.studio.apacheds.model.ServersHandlerIOException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServersHandlerIO {
    private static final String SERVERS_TAG = "servers";
    private static final String SERVER_TAG = "server";
    private static final String SERVER_ID_ATTRIBUTE = "id";
    private static final String SERVER_NAME_ATTRIBUTE = "name";
    private static final String SERVER_VERSION_ATTRIBUTE = "version";

    public static List<Server> read(InputStream stream) throws ServersHandlerIOException {
        ArrayList<Server> servers = new ArrayList<Server>();
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(stream);
        }
        catch (DocumentException e) {
            throw new ServersHandlerIOException(e.getMessage());
        }
        Element rootElement = document.getRootElement();
        if (!rootElement.getName().equals(SERVERS_TAG)) {
            throw new ServersHandlerIOException(Messages.getString("ServersHandlerIO.ErrorNotValidServersFile"));
        }
        Iterator i = rootElement.elementIterator(SERVER_TAG);
        while (i.hasNext()) {
            servers.add(ServersHandlerIO.readServer((Element)i.next()));
        }
        return servers;
    }

    private static Server readServer(Element element) {
        Attribute versionAttribute;
        Attribute nameAttribute;
        Server server = new Server();
        Attribute idAttribute = element.attribute(SERVER_ID_ATTRIBUTE);
        if (idAttribute != null) {
            server.setId(idAttribute.getValue());
        }
        if ((nameAttribute = element.attribute(SERVER_NAME_ATTRIBUTE)) != null) {
            server.setName(nameAttribute.getValue());
        }
        if ((versionAttribute = element.attribute(SERVER_VERSION_ATTRIBUTE)) != null) {
            if (versionAttribute.getValue().equalsIgnoreCase("1.5.6")) {
                server.setVersion(ServerVersion.VERSION_1_5_6);
            } else if (versionAttribute.getValue().equalsIgnoreCase("1.5.5")) {
                server.setVersion(ServerVersion.VERSION_1_5_5);
            } else if (versionAttribute.getValue().equalsIgnoreCase("1.5.4")) {
                server.setVersion(ServerVersion.VERSION_1_5_4);
            } else if (versionAttribute.getValue().equalsIgnoreCase("1.5.3")) {
                server.setVersion(ServerVersion.VERSION_1_5_3);
            } else {
                server.setVersion(ServerVersion.VERSION_1_5_3);
            }
        } else {
            server.setVersion(ServerVersion.VERSION_1_5_3);
        }
        return server;
    }

    public static void write(List<Server> servers, OutputStream outputStream) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(SERVERS_TAG);
        if (servers != null) {
            for (Server server : servers) {
                ServersHandlerIO.addServer(server, root);
            }
        }
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter(outputStream, outformat);
        writer.write(document);
        writer.flush();
    }

    private static void addServer(Server server, Element parent) {
        Element serverElement = parent.addElement(SERVER_TAG);
        serverElement.addAttribute(SERVER_ID_ATTRIBUTE, server.getId());
        serverElement.addAttribute(SERVER_NAME_ATTRIBUTE, server.getName());
        serverElement.addAttribute(SERVER_VERSION_ATTRIBUTE, server.getVersion().toString());
    }
}

