/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.actions;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.ApacheDsPluginConstants;
import org.apache.directory.studio.apacheds.ApacheDsPluginUtils;
import org.apache.directory.studio.apacheds.actions.Messages;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIOException;
import org.apache.directory.studio.apacheds.configuration.model.v153.ServerConfigurationV153;
import org.apache.directory.studio.apacheds.configuration.model.v154.ServerConfigurationV154;
import org.apache.directory.studio.apacheds.configuration.model.v155.ServerConfigurationV155;
import org.apache.directory.studio.apacheds.configuration.model.v156.ServerConfigurationV156;
import org.apache.directory.studio.apacheds.jobs.LaunchServerJob;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.views.ServersView;
import org.apache.mina.util.AvailablePortFinder;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RunAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private ServersView view;

    public RunAction() {
        super(Messages.getString("RunAction.Run"));
        this.init();
    }

    public RunAction(ServersView view) {
        super(Messages.getString("RunAction.Run"));
        this.view = view;
        this.init();
    }

    private void init() {
        this.setId(ApacheDsPluginConstants.CMD_RUN);
        this.setActionDefinitionId(ApacheDsPluginConstants.CMD_RUN);
        this.setToolTipText(Messages.getString("RunAction.RunToolTip"));
        this.setImageDescriptor(ApacheDsPlugin.getDefault().getImageDescriptor("resources/icons/run.gif"));
    }

    public void run() {
        StructuredSelection selection;
        if (this.view != null && !(selection = (StructuredSelection)this.view.getViewer().getSelection()).isEmpty() && selection.size() == 1) {
            Server server = (Server)selection.getFirstElement();
            ServerConfiguration serverConfiguration = null;
            try {
                serverConfiguration = ApacheDsPluginUtils.getServerConfiguration(server);
            }
            catch (IOException e) {
                this.reportErrorReadingServerConfiguration(e.getMessage());
                return;
            }
            catch (ServerXmlIOException e) {
                this.reportErrorReadingServerConfiguration(e.getMessage());
                return;
            }
            if (serverConfiguration == null) {
                this.reportErrorReadingServerConfiguration(null);
                return;
            }
            String[] alreadyInUseProtocolPortsList = this.getAlreadyInUseProtocolPorts(serverConfiguration);
            if (alreadyInUseProtocolPortsList != null && alreadyInUseProtocolPortsList.length > 0) {
                String title = null;
                String message = null;
                if (alreadyInUseProtocolPortsList.length == 1) {
                    title = Messages.getString("RunAction.PortInUse");
                    message = NLS.bind((String)Messages.getString("RunAction.PortOfProtocolInUse"), (Object[])new String[]{alreadyInUseProtocolPortsList[0]});
                } else {
                    title = Messages.getString("RunAction.PortsInUse");
                    message = Messages.getString("RunAction.PortsOfProtocolsInUse");
                    for (String alreadyInUseProtocolPort : alreadyInUseProtocolPortsList) {
                        message = message + ApacheDsPluginUtils.LINE_SEPARATOR + "    - " + alreadyInUseProtocolPort;
                    }
                }
                message = message + ApacheDsPluginUtils.LINE_SEPARATOR + ApacheDsPluginUtils.LINE_SEPARATOR + Messages.getString("RunAction.Continue");
                MessageDialog dialog = new MessageDialog(this.view.getSite().getShell(), title, null, message, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                if (dialog.open() == 1) {
                    return;
                }
            }
            ApacheDsPluginUtils.verifyLibrariesFolder(server);
            LaunchServerJob job = new LaunchServerJob(server, serverConfiguration);
            job.setLogsLevel(ApacheDsPluginUtils.getServerLogsLevel());
            job.setLogsPattern(ApacheDsPluginUtils.getServerLogsPattern());
            server.setLaunchJob(job);
            job.schedule();
        }
    }

    private void reportErrorReadingServerConfiguration(String errorMessage) {
        String message = null;
        message = errorMessage == null ? Messages.getString("RunAction.UnableReadServerConfiguration") : Messages.getString("RunAction.UnableReadServerConfiguration") + ApacheDsPluginUtils.LINE_SEPARATOR + ApacheDsPluginUtils.LINE_SEPARATOR + Messages.getString("RunAction.FollowingErrorOccurred") + errorMessage;
        MessageDialog dialog = new MessageDialog(this.view.getSite().getShell(), Messages.getString("RunAction.UnableReadServerConfiguration"), null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    private String[] getAlreadyInUseProtocolPorts(ServerConfiguration serverConfiguration) {
        if (serverConfiguration instanceof ServerConfigurationV156) {
            return this.getAlreadyInUseProtocolPortsVersion156((ServerConfigurationV156)serverConfiguration);
        }
        if (serverConfiguration instanceof ServerConfigurationV155) {
            return this.getAlreadyInUseProtocolPortsVersion155((ServerConfigurationV155)serverConfiguration);
        }
        if (serverConfiguration instanceof ServerConfigurationV154) {
            return this.getAlreadyInUseProtocolPortsVersion154((ServerConfigurationV154)serverConfiguration);
        }
        if (serverConfiguration instanceof ServerConfigurationV153) {
            return this.getAlreadyInUseProtocolPortsVersion153((ServerConfigurationV153)serverConfiguration);
        }
        return new String[0];
    }

    private String[] getAlreadyInUseProtocolPortsVersion153(ServerConfigurationV153 serverConfiguration) {
        ArrayList<String> alreadyInUseProtocolPortsList = new ArrayList<String>();
        if (serverConfiguration.isEnableLdap() && !AvailablePortFinder.available((int)serverConfiguration.getLdapPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.LDAPPort"), (Object[])new Object[]{serverConfiguration.getLdapPort()}));
        }
        if (serverConfiguration.isEnableLdaps() && !AvailablePortFinder.available((int)serverConfiguration.getLdapsPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.LDAPSPort"), (Object[])new Object[]{serverConfiguration.getLdapsPort()}));
        }
        if (serverConfiguration.isEnableKerberos() && !AvailablePortFinder.available((int)serverConfiguration.getKerberosPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.KerberosPort"), (Object[])new Object[]{serverConfiguration.getKerberosPort()}));
        }
        if (serverConfiguration.isEnableDns() && !AvailablePortFinder.available((int)serverConfiguration.getDnsPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.DNSPort"), (Object[])new Object[]{serverConfiguration.getDnsPort()}));
        }
        if (serverConfiguration.isEnableNtp() && !AvailablePortFinder.available((int)serverConfiguration.getNtpPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.NTPPort"), (Object[])new Object[]{serverConfiguration.getNtpPort()}));
        }
        if (serverConfiguration.isEnableChangePassword() && !AvailablePortFinder.available((int)serverConfiguration.getChangePasswordPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.ChangePasswordPort"), (Object[])new Object[]{serverConfiguration.getChangePasswordPort()}));
        }
        return alreadyInUseProtocolPortsList.toArray(new String[0]);
    }

    private String[] getAlreadyInUseProtocolPortsVersion154(ServerConfigurationV154 serverConfiguration) {
        ArrayList<String> alreadyInUseProtocolPortsList = new ArrayList<String>();
        if (serverConfiguration.isEnableLdap() && !AvailablePortFinder.available((int)serverConfiguration.getLdapPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.LDAPPort"), (Object[])new Object[]{serverConfiguration.getLdapPort()}));
        }
        if (serverConfiguration.isEnableLdaps() && !AvailablePortFinder.available((int)serverConfiguration.getLdapsPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.LDAPSPort"), (Object[])new Object[]{serverConfiguration.getLdapsPort()}));
        }
        if (serverConfiguration.isEnableKerberos() && !AvailablePortFinder.available((int)serverConfiguration.getKerberosPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.KerberosPort"), (Object[])new Object[]{serverConfiguration.getKerberosPort()}));
        }
        if (serverConfiguration.isEnableDns() && !AvailablePortFinder.available((int)serverConfiguration.getDnsPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.DNSPort"), (Object[])new Object[]{serverConfiguration.getDnsPort()}));
        }
        if (serverConfiguration.isEnableNtp() && !AvailablePortFinder.available((int)serverConfiguration.getNtpPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.NTPPort"), (Object[])new Object[]{serverConfiguration.getNtpPort()}));
        }
        if (serverConfiguration.isEnableChangePassword() && !AvailablePortFinder.available((int)serverConfiguration.getChangePasswordPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.ChangePasswordPort"), (Object[])new Object[]{serverConfiguration.getChangePasswordPort()}));
        }
        return alreadyInUseProtocolPortsList.toArray(new String[0]);
    }

    private String[] getAlreadyInUseProtocolPortsVersion155(ServerConfigurationV155 serverConfiguration) {
        ArrayList<String> alreadyInUseProtocolPortsList = new ArrayList<String>();
        if (serverConfiguration.isEnableLdap() && !AvailablePortFinder.available((int)serverConfiguration.getLdapPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.LDAPPort"), (Object[])new Object[]{serverConfiguration.getLdapPort()}));
        }
        if (serverConfiguration.isEnableLdaps() && !AvailablePortFinder.available((int)serverConfiguration.getLdapsPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.LDAPSPort"), (Object[])new Object[]{serverConfiguration.getLdapsPort()}));
        }
        if (serverConfiguration.isEnableKerberos() && !AvailablePortFinder.available((int)serverConfiguration.getKerberosPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.KerberosPort"), (Object[])new Object[]{serverConfiguration.getKerberosPort()}));
        }
        if (serverConfiguration.isEnableDns() && !AvailablePortFinder.available((int)serverConfiguration.getDnsPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.DNSPort"), (Object[])new Object[]{serverConfiguration.getDnsPort()}));
        }
        if (serverConfiguration.isEnableNtp() && !AvailablePortFinder.available((int)serverConfiguration.getNtpPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.NTPPort"), (Object[])new Object[]{serverConfiguration.getNtpPort()}));
        }
        if (serverConfiguration.isEnableChangePassword() && !AvailablePortFinder.available((int)serverConfiguration.getChangePasswordPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.ChangePasswordPort"), (Object[])new Object[]{serverConfiguration.getChangePasswordPort()}));
        }
        return alreadyInUseProtocolPortsList.toArray(new String[0]);
    }

    private String[] getAlreadyInUseProtocolPortsVersion156(ServerConfigurationV156 serverConfiguration) {
        ArrayList<String> alreadyInUseProtocolPortsList = new ArrayList<String>();
        if (serverConfiguration.isEnableLdap() && !AvailablePortFinder.available((int)serverConfiguration.getLdapPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.LDAPPort"), (Object[])new Object[]{serverConfiguration.getLdapPort()}));
        }
        if (serverConfiguration.isEnableLdaps() && !AvailablePortFinder.available((int)serverConfiguration.getLdapsPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.LDAPSPort"), (Object[])new Object[]{serverConfiguration.getLdapsPort()}));
        }
        if (serverConfiguration.isEnableKerberos() && !AvailablePortFinder.available((int)serverConfiguration.getKerberosPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.KerberosPort"), (Object[])new Object[]{serverConfiguration.getKerberosPort()}));
        }
        if (serverConfiguration.isEnableDns() && !AvailablePortFinder.available((int)serverConfiguration.getDnsPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.DNSPort"), (Object[])new Object[]{serverConfiguration.getDnsPort()}));
        }
        if (serverConfiguration.isEnableNtp() && !AvailablePortFinder.available((int)serverConfiguration.getNtpPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.NTPPort"), (Object[])new Object[]{serverConfiguration.getNtpPort()}));
        }
        if (serverConfiguration.isEnableChangePassword() && !AvailablePortFinder.available((int)serverConfiguration.getChangePasswordPort())) {
            alreadyInUseProtocolPortsList.add(NLS.bind((String)Messages.getString("RunAction.ChangePasswordPort"), (Object[])new Object[]{serverConfiguration.getChangePasswordPort()}));
        }
        return alreadyInUseProtocolPortsList.toArray(new String[0]);
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

