/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.actions;

import java.io.File;
import org.apache.directory.studio.apacheds.ApacheDsPluginConstants;
import org.apache.directory.studio.apacheds.ApacheDsPluginUtils;
import org.apache.directory.studio.apacheds.actions.Messages;
import org.apache.directory.studio.apacheds.dialogs.DeleteServerDialog;
import org.apache.directory.studio.apacheds.jobs.LaunchServerJob;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.model.ServerStateEnum;
import org.apache.directory.studio.apacheds.model.ServersHandler;
import org.apache.directory.studio.apacheds.views.ServersView;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class DeleteAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private ServersView view;

    public DeleteAction() {
        super(Messages.getString("DeleteAction.Delete"));
        this.init();
    }

    public DeleteAction(ServersView view) {
        super(Messages.getString("DeleteAction.Delete"));
        this.view = view;
        this.init();
    }

    private void init() {
        this.setId(ApacheDsPluginConstants.CMD_DELETE);
        this.setActionDefinitionId(ApacheDsPluginConstants.CMD_DELETE);
        this.setToolTipText(Messages.getString("DeleteAction.DeleteToolTip"));
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void run() {
        if (this.view != null) {
            StructuredSelection selection = (StructuredSelection)this.view.getViewer().getSelection();
            Server server = (Server)selection.getFirstElement();
            DeleteServerDialog dsd = new DeleteServerDialog(this.view.getSite().getShell(), server);
            if (dsd.open() == 0) {
                if (server.getState() == ServerStateEnum.STARTED) {
                    ILaunch launch;
                    server.setState(ServerStateEnum.STOPPING);
                    LaunchServerJob launchJob = server.getLaunchJob();
                    if (launchJob != null && (launch = launchJob.getLaunch()) != null && !launch.isTerminated()) {
                        try {
                            launch.terminate();
                        }
                        catch (DebugException e) {
                            ApacheDsPluginUtils.reportError(Messages.getString("DeleteAction.ErrorWhileStopping") + e.getMessage());
                        }
                    }
                }
                ServersHandler.getDefault().removeServer(server);
                this.deleteDirectory(new File(ApacheDsPluginUtils.getApacheDsServersFolder().append(server.getId()).toOSString()));
            }
        }
    }

    private boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

