/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.actions;

import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.actions.Messages;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.v153.ServerConfigurationV153;
import org.apache.directory.studio.apacheds.configuration.model.v154.ServerConfigurationV154;
import org.apache.directory.studio.apacheds.configuration.model.v155.ServerConfigurationV155;
import org.apache.directory.studio.apacheds.configuration.model.v156.ServerConfigurationV156;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateConnectionActionHelper {
    public static void createLdapBrowserConnection(String serverName, ServerConfiguration serverConfiguration) {
        ConnectionParameter connectionParameter = new ConnectionParameter();
        connectionParameter.setAuthMethod(ConnectionParameter.AuthenticationMethod.SIMPLE);
        if (serverConfiguration instanceof ServerConfigurationV156) {
            ServerConfigurationV156 serverConfigurationV156 = (ServerConfigurationV156)serverConfiguration;
            if (serverConfigurationV156.isEnableLdap()) {
                connectionParameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.NONE);
                connectionParameter.setPort(serverConfigurationV156.getLdapPort());
            } else if (serverConfigurationV156.isEnableLdaps()) {
                connectionParameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.LDAPS);
                connectionParameter.setPort(serverConfigurationV156.getLdapsPort());
            }
        } else if (serverConfiguration instanceof ServerConfigurationV155) {
            ServerConfigurationV155 serverConfiguration155 = (ServerConfigurationV155)serverConfiguration;
            if (serverConfiguration155.isEnableLdap()) {
                connectionParameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.NONE);
                connectionParameter.setPort(serverConfiguration155.getLdapPort());
            } else if (serverConfiguration155.isEnableLdaps()) {
                connectionParameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.LDAPS);
                connectionParameter.setPort(serverConfiguration155.getLdapsPort());
            }
        } else if (serverConfiguration instanceof ServerConfigurationV154) {
            ServerConfigurationV154 serverConfiguration154 = (ServerConfigurationV154)serverConfiguration;
            if (serverConfiguration154.isEnableLdap()) {
                connectionParameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.NONE);
                connectionParameter.setPort(serverConfiguration154.getLdapPort());
            } else if (serverConfiguration154.isEnableLdaps()) {
                connectionParameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.LDAPS);
                connectionParameter.setPort(serverConfiguration154.getLdapsPort());
            }
        } else if (serverConfiguration instanceof ServerConfigurationV153) {
            ServerConfigurationV153 serverConfiguration153 = (ServerConfigurationV153)serverConfiguration;
            if (serverConfiguration153.isEnableLdap()) {
                connectionParameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.NONE);
                connectionParameter.setPort(serverConfiguration153.getLdapPort());
            } else if (serverConfiguration153.isEnableLdaps()) {
                connectionParameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.LDAPS);
                connectionParameter.setPort(serverConfiguration153.getLdapsPort());
            }
        }
        connectionParameter.setBindPassword("secret");
        connectionParameter.setBindPrincipal("uid=admin,ou=system");
        connectionParameter.setHost("localhost");
        connectionParameter.setName(serverName);
        Connection connection = new Connection(connectionParameter);
        ConnectionCorePlugin.getDefault().getConnectionManager().addConnection(connection);
        ConnectionCorePlugin.getDefault().getConnectionFolderManager().getRootConnectionFolder().addConnectionId(connection.getId());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPerspectiveDescriptor ldapPerspective = CreateConnectionActionHelper.getLdapPerspective();
        IPerspectiveDescriptor currentPerspective = window.getActivePage().getPerspective();
        if (ldapPerspective != null && ldapPerspective.equals(currentPerspective)) {
            MessageDialog dialog = new MessageDialog(window.getShell(), Messages.getString("CreateConnectionActionHelper.ConnectionCreated"), null, NLS.bind((String)Messages.getString("CreateConnectionActionHelper.ConnectionCalledCreated"), (Object[])new String[]{connection.getName()}), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
        } else {
            MessageDialog dialog = new MessageDialog(window.getShell(), Messages.getString("CreateConnectionActionHelper.ConnectionCreated"), null, NLS.bind((String)Messages.getString("CreateConnectionActionHelper.ConnectionCalledCreatedSwitch"), (Object[])new String[]{connection.getName()}), 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (dialog.open() == 0) {
                window.getActivePage().setPerspective(ldapPerspective);
            }
        }
    }

    private static IPerspectiveDescriptor getLdapPerspective() {
        for (IPerspectiveDescriptor perspective : PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives()) {
            if (!ApacheDsPlugin.getDefault().getPluginProperties().getString("Perspective_LdapBrowserPerspective_id").equalsIgnoreCase(perspective.getId())) continue;
            return perspective;
        }
        return null;
    }
}

