/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.actions;

import java.io.IOException;
import java.util.PropertyResourceBundle;
import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.ApacheDsPluginConstants;
import org.apache.directory.studio.apacheds.ApacheDsPluginUtils;
import org.apache.directory.studio.apacheds.actions.CreateConnectionActionHelper;
import org.apache.directory.studio.apacheds.actions.Messages;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIOException;
import org.apache.directory.studio.apacheds.configuration.model.v153.ServerConfigurationV153;
import org.apache.directory.studio.apacheds.configuration.model.v154.ServerConfigurationV154;
import org.apache.directory.studio.apacheds.configuration.model.v155.ServerConfigurationV155;
import org.apache.directory.studio.apacheds.configuration.model.v156.ServerConfigurationV156;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.views.ServersView;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.osgi.framework.Bundle;

public class CreateConnectionAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private ServersView view;

    public CreateConnectionAction() {
        super(Messages.getString("CreateConnectionAction.CreateAConnection"));
        this.init();
    }

    public CreateConnectionAction(ServersView view) {
        super(Messages.getString("CreateConnectionAction.CreateAConnection"));
        this.view = view;
        this.init();
    }

    private void init() {
        this.setId(ApacheDsPluginConstants.CMD_CREATE_CONNECTION);
        this.setActionDefinitionId(ApacheDsPluginConstants.CMD_CREATE_CONNECTION);
        this.setToolTipText(Messages.getString("CreateConnectionAction.StopToolTip"));
        this.setImageDescriptor(ApacheDsPlugin.getDefault().getImageDescriptor("resources/icons/connection_new.gif"));
    }

    public void run() {
        StructuredSelection selection;
        if (this.view != null && !(selection = (StructuredSelection)this.view.getViewer().getSelection()).isEmpty() && selection.size() == 1) {
            Server server = (Server)selection.getFirstElement();
            ServerConfiguration serverConfiguration = null;
            try {
                serverConfiguration = ApacheDsPluginUtils.getServerConfiguration(server);
            }
            catch (IOException e) {
                this.reportErrorReadingServerConfiguration(e.getMessage());
                return;
            }
            catch (ServerXmlIOException e) {
                this.reportErrorReadingServerConfiguration(e.getMessage());
                return;
            }
            if (serverConfiguration == null) {
                this.reportErrorReadingServerConfiguration(null);
                return;
            }
            if (this.isEnableLdapOrLdaps(serverConfiguration)) {
                CreateConnectionActionHelper.createLdapBrowserConnection(server.getName(), serverConfiguration);
            } else {
                MessageDialog dialog = new MessageDialog(this.view.getSite().getShell(), Messages.getString("CreateConnectionAction.UnableCreateConnection"), null, Messages.getString("CreateConnectionAction.LDAPAndLDAPSDisabled"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            }
        }
    }

    private void reportErrorReadingServerConfiguration(String errorMessage) {
        String message = null;
        message = errorMessage == null ? Messages.getString("CreateConnectionAction.UnableReadServerConfiguration") : Messages.getString("CreateConnectionAction.UnableReadServerConfiguration") + ApacheDsPluginUtils.LINE_SEPARATOR + ApacheDsPluginUtils.LINE_SEPARATOR + Messages.getString("CreateConnectionAction.FollowingErrorOccurred") + errorMessage;
        MessageDialog dialog = new MessageDialog(this.view.getSite().getShell(), Messages.getString("CreateConnectionAction.UnableReadServerConfiguration"), null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    private boolean isEnableLdapOrLdaps(ServerConfiguration serverConfiguration) {
        if (serverConfiguration instanceof ServerConfigurationV156) {
            ServerConfigurationV156 serverConfiguration156 = (ServerConfigurationV156)serverConfiguration;
            return serverConfiguration156.isEnableLdap() || serverConfiguration156.isEnableLdaps();
        }
        if (serverConfiguration instanceof ServerConfigurationV155) {
            ServerConfigurationV155 serverConfiguration155 = (ServerConfigurationV155)serverConfiguration;
            return serverConfiguration155.isEnableLdap() || serverConfiguration155.isEnableLdaps();
        }
        if (serverConfiguration instanceof ServerConfigurationV154) {
            ServerConfigurationV154 serverConfiguration154 = (ServerConfigurationV154)serverConfiguration;
            return serverConfiguration154.isEnableLdap() || serverConfiguration154.isEnableLdaps();
        }
        if (serverConfiguration instanceof ServerConfigurationV153) {
            ServerConfigurationV153 serverConfiguration153 = (ServerConfigurationV153)serverConfiguration;
            return serverConfiguration153.isEnableLdap() || serverConfiguration153.isEnableLdaps();
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setEnabled(this.isLdapBrowserPluginsAvailable());
        } else {
            super.setEnabled(enabled);
        }
    }

    private boolean isLdapBrowserPluginsAvailable() {
        PropertyResourceBundle properties = ApacheDsPlugin.getDefault().getPluginProperties();
        Bundle connectionCoreBundle = Platform.getBundle((String)properties.getString("Plugin_ConnectionCore_id"));
        if (connectionCoreBundle != null) {
            if (connectionCoreBundle.getState() == 1) {
                return false;
            }
            Bundle connectionUiBundle = Platform.getBundle((String)properties.getString("Plugin_ConnectionUi_id"));
            if (connectionUiBundle != null) {
                if (connectionUiBundle.getState() == 1) {
                    return false;
                }
                Bundle ldapBrowserCommonBundle = Platform.getBundle((String)properties.getString("Plugin_LdapBrowserCommon_id"));
                if (ldapBrowserCommonBundle != null) {
                    if (ldapBrowserCommonBundle.getState() == 1) {
                        return false;
                    }
                    Bundle ldapBrowserCoreBundle = Platform.getBundle((String)properties.getString("Plugin_LdapBrowserCore_id"));
                    if (ldapBrowserCoreBundle != null) {
                        if (ldapBrowserCoreBundle.getState() == 1) {
                            return false;
                        }
                        Bundle ldapBrowserUiBundle = Platform.getBundle((String)properties.getString("Plugin_LdapBrowserUi_id"));
                        if (ldapBrowserUiBundle != null) {
                            if (ldapBrowserUiBundle.getState() == 1) {
                                return false;
                            }
                            Bundle ldifEditorBundle = Platform.getBundle((String)properties.getString("Plugin_LdifEditor_id"));
                            if (ldifEditorBundle != null) {
                                if (ldifEditorBundle.getState() == 1) {
                                    return false;
                                }
                                Bundle ldifParserBundle = Platform.getBundle((String)properties.getString("Plugin_LdifParser_id"));
                                if (ldifParserBundle != null) {
                                    if (ldifParserBundle.getState() == 1) {
                                        return false;
                                    }
                                    Bundle jarsBundle = Platform.getBundle((String)properties.getString("Plugin_Jars_id"));
                                    if (jarsBundle != null) {
                                        return jarsBundle.getState() != 1;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

