/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.studio.apacheds.LogMessageConsole;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.model.ServersHandler;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class ConsolesHandler {
    private static ConsolesHandler instance;
    private Map<String, LogMessageConsole> consolesMap = new HashMap<String, LogMessageConsole>();

    private ConsolesHandler() {
    }

    public static ConsolesHandler getDefault() {
        if (instance == null) {
            instance = new ConsolesHandler();
        }
        return instance;
    }

    public LogMessageConsole getLogMessageConsole(String serverId) {
        if (this.consolesMap.containsKey(serverId)) {
            return this.consolesMap.get(serverId);
        }
        Server server = ServersHandler.getDefault().getServerById(serverId);
        LogMessageConsole logMessageConsole = new LogMessageConsole("Apache DS - " + server.getName());
        this.consolesMap.put(serverId, logMessageConsole);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{logMessageConsole});
        return logMessageConsole;
    }
}

