/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifeditor.LdifEditorConstants;
import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.LdifInvalidPart;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModDnRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModifyRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifInvalidContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifSepContainer;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

public class LdifCompletionProcessor
extends TemplateCompletionProcessor {
    private static final String CT_ADD = "changetype: add" + BrowserCoreConstants.LINE_SEPARATOR;
    private static final String CT_MODIFY = "changetype: modify" + BrowserCoreConstants.LINE_SEPARATOR;
    private static final String CT_DELETE = "changetype: delete" + BrowserCoreConstants.LINE_SEPARATOR;
    private static final String CT_MODDN = "changetype: moddn" + BrowserCoreConstants.LINE_SEPARATOR;
    private static final String MD_NEWRDN = "newrdn: ";
    private static final String MD_DELETEOLDRDN_TRUE = "deleteoldrdn: 1";
    private static final String MD_NEWSUPERIOR = "newsuperior: ";
    private final ILdifEditor editor;
    private final ContentAssistant contentAssistant;

    public LdifCompletionProcessor(ILdifEditor editor, ContentAssistant contentAssistant) {
        this.editor = editor;
        this.contentAssistant = contentAssistant;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        LdifModSpec modSpec;
        String att;
        LdifRecord record;
        LdifPart[] parts;
        IPreferenceStore store = LdifEditorActivator.getDefault().getPreferenceStore();
        this.contentAssistant.enableAutoInsert(store.getBoolean("ldifEditorCodeAssistInsertSingleProposalAuto"));
        this.contentAssistant.enableAutoActivation(store.getBoolean("ldifEditorCodeAssistEnableAutoActivation"));
        this.contentAssistant.setAutoActivationDelay(store.getInt("ldifEditorCodeAssistAutoActivationDelay"));
        ArrayList<Object> proposalList = new ArrayList<Object>();
        LdifFile model = this.editor.getLdifModel();
        LdifContainer container = LdifFile.getContainer((LdifFile)model, (int)offset);
        LdifModSpec innerContainer = container != null ? LdifFile.getInnerContainer((LdifContainer)container, (int)offset) : null;
        LdifPart part = container != null ? LdifFile.getContainerContent((LdifContainer)container, (int)offset) : null;
        int documentLine = -1;
        int documentLineOffset = -1;
        String prefix = "";
        try {
            documentLine = viewer.getDocument().getLineOfOffset(offset);
            documentLineOffset = viewer.getDocument().getLineOffset(documentLine);
            prefix = viewer.getDocument().get(documentLineOffset, offset - documentLineOffset);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        ICompletionProposal[] templateProposals = super.computeCompletionProposals(viewer, offset);
        if (templateProposals != null) {
            proposalList.addAll(Arrays.asList(templateProposals));
        }
        if (!(!(container instanceof LdifRecord) || (parts = (record = (LdifRecord)container).getParts()).length <= 1 || parts[1] instanceof LdifChangeTypeLine && parts[1].isValid())) {
            if (CT_ADD.startsWith(prefix)) {
                proposalList.add(new CompletionProposal(CT_ADD, offset - prefix.length(), prefix.length(), CT_ADD.length(), LdifEditorActivator.getDefault().getImage("resources/icons/ldif_add.gif"), CT_ADD.substring(0, CT_ADD.length() - BrowserCoreConstants.LINE_SEPARATOR.length()), null, null));
            }
            if (CT_MODIFY.startsWith(prefix)) {
                proposalList.add(new CompletionProposal(CT_MODIFY, offset - prefix.length(), prefix.length(), CT_MODIFY.length(), LdifEditorActivator.getDefault().getImage("resources/icons/ldif_modify.gif"), CT_MODIFY.substring(0, CT_MODIFY.length() - BrowserCoreConstants.LINE_SEPARATOR.length()), null, null));
            }
            if (CT_DELETE.startsWith(prefix)) {
                proposalList.add(new CompletionProposal(CT_DELETE, offset - prefix.length(), prefix.length(), CT_DELETE.length(), LdifEditorActivator.getDefault().getImage("resources/icons/ldif_delete.gif"), CT_DELETE.substring(0, CT_DELETE.length() - BrowserCoreConstants.LINE_SEPARATOR.length()), null, null));
            }
            if (CT_MODDN.startsWith(prefix)) {
                proposalList.add(new CompletionProposal(CT_MODDN, offset - prefix.length(), prefix.length(), CT_MODDN.length(), LdifEditorActivator.getDefault().getImage("resources/icons/ldif_rename.gif"), CT_MODDN.substring(0, CT_MODDN.length() - BrowserCoreConstants.LINE_SEPARATOR.length()), null, null));
            }
        }
        if (container instanceof LdifChangeModDnRecord) {
            record = (LdifChangeModDnRecord)container;
            if ((record.getNewrdnLine() == null || !record.getNewrdnLine().isValid()) && MD_NEWRDN.startsWith(prefix)) {
                proposalList.add(new CompletionProposal(MD_NEWRDN, offset - prefix.length(), prefix.length(), MD_NEWRDN.length(), null, null, null, null));
            }
            if ((record.getDeloldrdnLine() == null || !record.getDeloldrdnLine().isValid()) && MD_DELETEOLDRDN_TRUE.startsWith(prefix)) {
                proposalList.add(new CompletionProposal(MD_DELETEOLDRDN_TRUE, offset - prefix.length(), prefix.length(), MD_DELETEOLDRDN_TRUE.length(), null, null, null, null));
            }
            if ((record.getNewsuperiorLine() == null || !record.getNewsuperiorLine().isValid()) && MD_NEWSUPERIOR.startsWith(prefix)) {
                proposalList.add(new CompletionProposal(MD_NEWSUPERIOR, offset - prefix.length(), prefix.length(), MD_NEWSUPERIOR.length(), null, null, null, null));
            }
        }
        if (innerContainer instanceof LdifModSpec && (att = (modSpec = innerContainer).getModSpecType().getRawAttributeDescription()) != null && att.startsWith(prefix)) {
            proposalList.add(new CompletionProposal(att, offset - prefix.length(), prefix.length(), att.length(), null, null, null, null));
        }
        if ((container instanceof LdifContentRecord || container instanceof LdifChangeAddRecord) && (part instanceof LdifInvalidPart || part instanceof LdifAttrValLine || part instanceof LdifSepLine && (container instanceof LdifContentRecord || container instanceof LdifChangeAddRecord))) {
            String rawAttributeDescription = prefix;
            String rawValueType = "";
            if (part instanceof LdifAttrValLine) {
                LdifAttrValLine line = (LdifAttrValLine)part;
                rawAttributeDescription = line.getRawAttributeDescription();
                rawValueType = line.getRawValueType();
            }
            if (offset <= part.getOffset() + rawAttributeDescription.length()) {
                Schema schema = this.editor.getConnection() != null ? this.editor.getConnection().getSchema() : Schema.DEFAULT_SCHEMA;
                Object[] attributeNames = SchemaUtils.getNamesAsArray((Collection)schema.getAttributeTypeDescriptions());
                Arrays.sort(attributeNames);
                for (Object attributeName : attributeNames) {
                    if (rawAttributeDescription.length() != 0 && !((String)attributeName).toLowerCase().startsWith(rawAttributeDescription.toLowerCase())) continue;
                    Object proposal = attributeName;
                    if (rawValueType.length() == 0) {
                        proposal = SchemaUtils.isBinary((AttributeTypeDescription)schema.getAttributeTypeDescription((String)proposal), (Schema)schema) ? (String)proposal + ":: " : (String)proposal + ": ";
                    }
                    proposalList.add(new CompletionProposal((String)proposal, offset - rawAttributeDescription.length(), rawAttributeDescription.length(), ((String)proposal).length()));
                }
            }
        }
        boolean commentOnly = false;
        if (documentLineOffset == offset) {
            commentOnly = proposalList.isEmpty();
            proposalList.add(new CompletionProposal("# ", offset, 0, 2, LdifEditorActivator.getDefault().getImage("resources/icons/ldif_comment.gif"), "# - Comment", null, null));
        }
        this.contentAssistant.enableAutoInsert(!commentOnly);
        ICompletionProposal[] proposals = proposalList.toArray(new ICompletionProposal[0]);
        return proposals;
    }

    protected String extractPrefix(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        if (offset > document.getLength()) {
            return "";
        }
        try {
            int documentLine = viewer.getDocument().getLineOfOffset(offset);
            int documentLineOffset = viewer.getDocument().getLineOffset(documentLine);
            String prefix = viewer.getDocument().get(documentLineOffset, offset - documentLineOffset);
            return prefix;
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        int i;
        char[] chars = new char[53];
        for (i = 0; i < 26; ++i) {
            chars[i] = (char)(97 + i);
        }
        for (i = 0; i < 26; ++i) {
            chars[i + 26] = (char)(65 + i);
        }
        chars[52] = 58;
        return chars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    protected Template[] getTemplates(String contextTypeId) {
        Template[] templates = LdifEditorActivator.getDefault().getLdifTemplateStore().getTemplates(contextTypeId);
        return templates;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        int offset = region.getOffset();
        LdifFile model = this.editor.getLdifModel();
        LdifContainer container = LdifFile.getContainer((LdifFile)model, (int)offset);
        LdifModSpec innerContainer = container != null ? LdifFile.getInnerContainer((LdifContainer)container, (int)offset) : null;
        LdifPart part = container != null ? LdifFile.getContainerContent((LdifContainer)container, (int)offset) : null;
        int documentLine = -1;
        int documentLineOffset = -1;
        String prefix = "";
        try {
            documentLine = viewer.getDocument().getLineOfOffset(offset);
            documentLineOffset = viewer.getDocument().getLineOffset(documentLine);
            prefix = viewer.getDocument().get(documentLineOffset, offset - documentLineOffset);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        if (container == null && innerContainer == null && part == null) {
            return LdifEditorActivator.getDefault().getLdifTemplateContextTypeRegistry().getContextType(LdifEditorConstants.LDIF_FILE_TEMPLATE_ID);
        }
        if (container instanceof LdifSepContainer && innerContainer == null && part instanceof LdifSepLine) {
            return LdifEditorActivator.getDefault().getLdifTemplateContextTypeRegistry().getContextType(LdifEditorConstants.LDIF_FILE_TEMPLATE_ID);
        }
        if (container instanceof LdifInvalidContainer && part instanceof LdifInvalidPart && "d".equals(prefix) || container instanceof LdifContentRecord && part instanceof LdifInvalidPart && "dn".equals(prefix) || container instanceof LdifContentRecord && part instanceof LdifInvalidPart && "dn:".equals(prefix)) {
            return LdifEditorActivator.getDefault().getLdifTemplateContextTypeRegistry().getContextType(LdifEditorConstants.LDIF_FILE_TEMPLATE_ID);
        }
        if (container instanceof LdifChangeModifyRecord && innerContainer == null && (part instanceof LdifSepLine || part instanceof LdifInvalidPart)) {
            return LdifEditorActivator.getDefault().getLdifTemplateContextTypeRegistry().getContextType(LdifEditorConstants.LDIF_MODIFICATION_RECORD_TEMPLATE_ID);
        }
        if (container instanceof LdifChangeModifyRecord && innerContainer instanceof LdifModSpec) {
            return LdifEditorActivator.getDefault().getLdifTemplateContextTypeRegistry().getContextType(LdifEditorConstants.LDIF_MODIFICATION_ITEM_TEMPLATE_ID);
        }
        if (container instanceof LdifChangeModDnRecord && innerContainer == null && (part instanceof LdifSepLine || part instanceof LdifInvalidPart)) {
            return LdifEditorActivator.getDefault().getLdifTemplateContextTypeRegistry().getContextType(LdifEditorConstants.LDIF_MODDN_RECORD_TEMPLATE_ID);
        }
        return null;
    }

    protected Image getImage(Template template) {
        if (template.getPattern().indexOf("add: ") > -1) {
            return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_mod_add.gif");
        }
        if (template.getPattern().indexOf("replace: ") > -1) {
            return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_mod_replace.gif");
        }
        if (template.getPattern().indexOf("delete: ") > -1) {
            return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_mod_delete.gif");
        }
        if (template.getPattern().indexOf("changetype: add") > -1) {
            return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_add.gif");
        }
        if (template.getPattern().indexOf("changetype: modify") > -1) {
            return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_modify.gif");
        }
        if (template.getPattern().indexOf("changetype: delete") > -1) {
            return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_delete.gif");
        }
        if (template.getPattern().indexOf("changetype: moddn") > -1) {
            return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_rename.gif");
        }
        if (template.getPattern().indexOf("dn: ") > -1) {
            return LdifEditorActivator.getDefault().getImage("resources/icons/entry.gif");
        }
        return LdifEditorActivator.getDefault().getImage("resources/icons/template.gif");
    }
}

