/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.reconciler;

import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifeditor.editor.LdifOutlinePage;
import org.apache.directory.studio.ldifeditor.editor.reconciler.LdifAnnotationUpdater;
import org.apache.directory.studio.ldifeditor.editor.reconciler.LdifFoldingRegionUpdater;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class LdifReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ILdifEditor editor;
    private LdifFoldingRegionUpdater foldingUpdater;
    private LdifAnnotationUpdater annotationUpdater;

    public LdifReconcilingStrategy(ILdifEditor editor) {
        this.editor = editor;
        this.annotationUpdater = new LdifAnnotationUpdater(this.editor);
        this.foldingUpdater = new LdifFoldingRegionUpdater(this.editor);
    }

    public void dispose() {
        this.annotationUpdater.dispose();
        this.foldingUpdater.dispose();
    }

    public void setDocument(IDocument document) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile();
    }

    public void reconcile(IRegion partition) {
        this.reconcile();
    }

    public void initialReconcile() {
        this.reconcile();
    }

    private void reconcile() {
        this.notifyEnvironment();
    }

    private void notifyEnvironment() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IContentOutlinePage outline = (IContentOutlinePage)LdifReconcilingStrategy.this.editor.getAdapter(IContentOutlinePage.class);
                if (outline != null && outline instanceof LdifOutlinePage) {
                    ((LdifOutlinePage)outline).refresh();
                }
                LdifReconcilingStrategy.this.annotationUpdater.updateAnnotations();
                LdifReconcilingStrategy.this.foldingUpdater.updateFoldingRegions();
            }
        });
    }
}

