/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.actions;

import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldifeditor.LdifEditorConstants;
import org.apache.directory.studio.ldifeditor.dialogs.LdifEntryEditorDialog;
import org.apache.directory.studio.ldifeditor.editor.LdifEditor;
import org.apache.directory.studio.ldifeditor.editor.actions.AbstractLdifAction;
import org.apache.directory.studio.ldifeditor.editor.actions.Messages;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.eclipse.jface.text.IDocument;

public class EditLdifRecordAction
extends AbstractLdifAction {
    public EditLdifRecordAction(LdifEditor editor) {
        super(Messages.getString("EditLdifRecordAction.EditRecord"), editor);
        super.setActionDefinitionId(LdifEditorConstants.ACTION_ID_EDIT_RECORD);
    }

    protected void doRun() {
        LdifContainer[] containers = this.getSelectedLdifContainers();
        if (containers.length == 1 && (containers[0] instanceof LdifContentRecord || containers[0] instanceof LdifChangeAddRecord)) {
            LdifContainer container = containers[0];
            LdifEntryEditorDialog dialog = null;
            dialog = container instanceof LdifContentRecord ? new LdifEntryEditorDialog(this.editor.getEditorSite().getShell(), this.editor.getConnection(), (LdifContentRecord)container) : new LdifEntryEditorDialog(this.editor.getEditorSite().getShell(), this.editor.getConnection(), (LdifChangeAddRecord)container);
            this.editor.deactivateGlobalActionHandlers();
            if (dialog.open() == 0) {
                LdifRecord record = dialog.getLdifRecord();
                IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
                String old = document.get();
                StringBuffer sb = new StringBuffer();
                sb.append(old.substring(0, container.getOffset()));
                sb.append(record.toFormattedString(Utils.getLdifFormatParameters()));
                sb.append(old.substring(container.getOffset() + container.getLength(), old.length()));
                document.set(sb.toString());
            }
            this.editor.activateGlobalActionHandlers();
        }
    }

    public void update() {
        LdifContainer[] containers = this.getSelectedLdifContainers();
        super.setEnabled(containers.length == 1 && (containers[0] instanceof LdifContentRecord || containers[0] instanceof LdifChangeAddRecord));
    }
}

