/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.actions;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.wizards.AttributeWizard;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyConnection;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldifeditor.editor.LdifEditor;
import org.apache.directory.studio.ldifeditor.editor.actions.AbstractLdifAction;
import org.apache.directory.studio.ldifeditor.editor.actions.Messages;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModifyRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifValueLineBase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class EditLdifAttributeAction
extends AbstractLdifAction {
    public EditLdifAttributeAction(LdifEditor editor) {
        super(Messages.getString("EditLdifAttributeAction.EditAttributeDescription"), editor);
        super.setActionDefinitionId(BrowserCommonConstants.ACTION_ID_EDIT_ATTRIBUTE_DESCRIPTION);
    }

    public void update() {
        LdifContainer[] containers = this.getSelectedLdifContainers();
        LdifModSpec modSpec = this.getSelectedLdifModSpec();
        LdifPart[] parts = this.getSelectedLdifParts();
        super.setEnabled(!(parts.length != 1 || !(parts[0] instanceof LdifAttrValLine) && modSpec == null || containers.length != 1 || !(containers[0] instanceof LdifContentRecord) && !(containers[0] instanceof LdifChangeAddRecord) && !(containers[0] instanceof LdifChangeModifyRecord)));
    }

    protected void doRun() {
        LdifContainer[] containers = this.getSelectedLdifContainers();
        LdifModSpec modSpec = this.getSelectedLdifModSpec();
        LdifPart[] parts = this.getSelectedLdifParts();
        if (parts.length == 1 && (parts[0] instanceof LdifAttrValLine || parts[0] instanceof LdifModSpecTypeLine) && containers.length == 1 && (containers[0] instanceof LdifContentRecord || containers[0] instanceof LdifChangeAddRecord || containers[0] instanceof LdifChangeModifyRecord)) {
            try {
                String newAttributeDescription;
                LdifAttrValLine oldLine;
                LdifValueLineBase line = (LdifValueLineBase)parts[0];
                String attributeDescription = null;
                String oldValue = null;
                if (modSpec != null && line instanceof LdifModSpecTypeLine) {
                    oldLine = (LdifModSpecTypeLine)line;
                    attributeDescription = oldLine.getUnfoldedAttributeDescription();
                    oldValue = null;
                } else {
                    oldLine = (LdifAttrValLine)line;
                    attributeDescription = oldLine.getUnfoldedAttributeDescription();
                    oldValue = oldLine.getValueAsString();
                }
                Schema schema = this.editor.getConnection() != null ? this.editor.getConnection().getSchema() : Schema.DEFAULT_SCHEMA;
                DummyConnection dummyConnection = new DummyConnection(schema);
                DummyEntry dummyEntry = null;
                if (containers[0] instanceof LdifContentRecord) {
                    dummyEntry = ModelConverter.ldifContentRecordToEntry((LdifContentRecord)((LdifContentRecord)containers[0]), (IBrowserConnection)dummyConnection);
                } else if (containers[0] instanceof LdifChangeAddRecord) {
                    dummyEntry = ModelConverter.ldifChangeAddRecordToEntry((LdifChangeAddRecord)((LdifChangeAddRecord)containers[0]), (IBrowserConnection)dummyConnection);
                } else if (containers[0] instanceof LdifChangeModifyRecord) {
                    dummyEntry = new DummyEntry(new LdapDN(), (IBrowserConnection)dummyConnection);
                }
                AttributeWizard wizard = new AttributeWizard(Messages.getString("EditLdifAttributeAction.EditAttributeDescription"), true, false, attributeDescription, (IEntry)dummyEntry);
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                dialog.setBlockOnOpen(true);
                dialog.create();
                if (dialog.open() == 0 && (newAttributeDescription = wizard.getAttributeDescription()) != null) {
                    IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
                    if (modSpec != null) {
                        LdifModSpecTypeLine oldTypeLine = modSpec.getModSpecType();
                        LdifModSpecTypeLine newTypeLine = null;
                        if (oldTypeLine.isAdd()) {
                            newTypeLine = LdifModSpecTypeLine.createAdd((String)newAttributeDescription);
                        } else if (oldTypeLine.isDelete()) {
                            newTypeLine = LdifModSpecTypeLine.createDelete((String)newAttributeDescription);
                        } else if (oldTypeLine.isReplace()) {
                            newTypeLine = LdifModSpecTypeLine.createReplace((String)newAttributeDescription);
                        }
                        LdifAttrValLine[] oldAttrValLines = modSpec.getAttrVals();
                        LdifAttrValLine[] newAttrValLines = new LdifAttrValLine[oldAttrValLines.length];
                        for (int i = 0; i < oldAttrValLines.length; ++i) {
                            LdifAttrValLine oldAttrValLine = oldAttrValLines[i];
                            newAttrValLines[i] = LdifAttrValLine.create((String)newAttributeDescription, (String)oldAttrValLine.getValueAsString());
                        }
                        LdifModSpecSepLine newSepLine = LdifModSpecSepLine.create();
                        String text = newTypeLine.toFormattedString(Utils.getLdifFormatParameters());
                        for (int j = 0; j < newAttrValLines.length; ++j) {
                            text = text + newAttrValLines[j].toFormattedString(Utils.getLdifFormatParameters());
                        }
                        text = text + newSepLine.toFormattedString(Utils.getLdifFormatParameters());
                        try {
                            document.replace(modSpec.getOffset(), modSpec.getLength(), text);
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    } else {
                        LdifAttrValLine newLine = LdifAttrValLine.create((String)newAttributeDescription, (String)oldValue);
                        try {
                            document.replace(line.getOffset(), line.getLength(), newLine.toFormattedString(Utils.getLdifFormatParameters()));
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (InvalidNameException e) {
                // empty catch block
            }
        }
    }
}

