/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserLabelProvider;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifeditor.editor.LdifEditor;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeDeleteRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModDnRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModifyRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class LdifOutlinePage
extends ContentOutlinePage {
    private LdifEditor ldifEditor;
    private boolean isLinkedToLdapBrowser = false;

    public LdifOutlinePage(LdifEditor ldifEditor) {
        this.ldifEditor = ldifEditor;
    }

    public LdifOutlinePage(LdifEditor ldifEditor, boolean isLinkedToLdapBrowser) {
        this.ldifEditor = ldifEditor;
        this.isLinkedToLdapBrowser = isLinkedToLdapBrowser;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        final TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setLabelProvider((IBaseLabelProvider)new LdifLabelProvider(this.ldifEditor, this.isLinkedToLdapBrowser));
        treeViewer.setContentProvider((IContentProvider)new LdifContentProvider());
        if (this.isLinkedToLdapBrowser) {
            treeViewer.setAutoExpandLevel(2);
        }
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                    Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (element instanceof LdifRecord) {
                        LdifRecord ldifRecord = (LdifRecord)element;
                        LdifOutlinePage.this.ldifEditor.selectAndReveal(ldifRecord.getDnLine().getOffset(), ldifRecord.getDnLine().getLength());
                    } else if (element instanceof List) {
                        List list = (List)element;
                        if (!list.isEmpty() && list.get(0) instanceof LdifAttrValLine) {
                            LdifAttrValLine line = (LdifAttrValLine)list.get(0);
                            LdifOutlinePage.this.ldifEditor.selectAndReveal(line.getOffset(), line.getRawAttributeDescription().length());
                        }
                    } else if (element instanceof LdifAttrValLine) {
                        LdifAttrValLine line = (LdifAttrValLine)element;
                        LdifOutlinePage.this.ldifEditor.selectAndReveal(line.getOffset() + line.getRawAttributeDescription().length() + line.getRawValueType().length(), line.getRawValue().length());
                    } else if (element instanceof LdifModSpec) {
                        LdifModSpec modSpec = (LdifModSpec)element;
                        LdifOutlinePage.this.ldifEditor.selectAndReveal(modSpec.getOffset(), modSpec.getModSpecType().getLength());
                    }
                }
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (treeViewer.getExpandedState(obj)) {
                        treeViewer.collapseToLevel(obj, 1);
                    } else if (((ITreeContentProvider)treeViewer.getContentProvider()).hasChildren(obj)) {
                        treeViewer.expandToLevel(obj, 1);
                    }
                }
            }
        });
        this.refresh();
    }

    public void refresh(Object element) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && treeViewer.getTree() != null && !treeViewer.getTree().isDisposed()) {
            treeViewer.refresh(element);
        }
    }

    public void refresh() {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && treeViewer.getTree() != null && !treeViewer.getTree().isDisposed()) {
            if (!treeViewer.getTree().isEnabled()) {
                treeViewer.getTree().setEnabled(true);
            }
            if (this.ldifEditor != null && treeViewer.getInput() != this.ldifEditor.getLdifModel()) {
                treeViewer.setInput((Object)this.ldifEditor.getLdifModel());
            }
            treeViewer.refresh();
            if (this.isLinkedToLdapBrowser) {
                treeViewer.setAutoExpandLevel(2);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.ldifEditor != null) {
            this.ldifEditor.outlinePageClosed();
            this.ldifEditor = null;
        }
    }

    private static class LdifLabelProvider
    extends LabelProvider {
        private LdifEditor ldifEditor;
        private boolean isLinkedToLdapBrowser = false;

        public LdifLabelProvider(LdifEditor ldifEditor, boolean isLinkedToLdapBrowser) {
            this.ldifEditor = ldifEditor;
            this.isLinkedToLdapBrowser = isLinkedToLdapBrowser;
        }

        public String getText(Object element) {
            if (element instanceof LdifRecord) {
                LdifRecord ldifRecord = (LdifRecord)element;
                return ldifRecord.getDnLine().getValueAsString();
            }
            if (element instanceof List && ((List)element).get(0) instanceof LdifAttrValLine) {
                List list = (List)element;
                return ((LdifAttrValLine)list.get(0)).getUnfoldedAttributeDescription() + " (" + list.size() + ")";
            }
            if (element instanceof LdifModSpec) {
                LdifModSpec modSpec = (LdifModSpec)element;
                return modSpec.getModSpecType().getUnfoldedAttributeDescription() + " (" + modSpec.getAttrVals().length + ")";
            }
            if (element instanceof LdifAttrValLine) {
                LdifAttrValLine line = (LdifAttrValLine)element;
                return Utils.getShortenedString((String)line.getValueAsString(), (int)20);
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof LdifContentRecord) {
                LdifContentRecord record;
                LdifDnLine dnLine;
                if (this.isLinkedToLdapBrowser && (dnLine = (record = (LdifContentRecord)element).getDnLine()) != null) {
                    String dn = dnLine.getRawDn();
                    if (dn != null && "".equals(dn)) {
                        return BrowserCommonActivator.getDefault().getImage("resources/icons/entry_root.gif");
                    }
                    try {
                        return BrowserLabelProvider.getImageByObjectClass((IEntry)this.ldifEditor.getConnection().getEntryFromCache(new LdapDN(dn)));
                    }
                    catch (InvalidNameException e) {
                        // empty catch block
                    }
                }
                return LdifEditorActivator.getDefault().getImage("resources/icons/entry.gif");
            }
            if (element instanceof LdifChangeAddRecord) {
                return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_add.gif");
            }
            if (element instanceof LdifChangeModifyRecord) {
                return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_modify.gif");
            }
            if (element instanceof LdifChangeDeleteRecord) {
                return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_delete.gif");
            }
            if (element instanceof LdifChangeModDnRecord) {
                return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_rename.gif");
            }
            if (element instanceof List && ((List)element).get(0) instanceof LdifAttrValLine) {
                return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_attribute.gif");
            }
            if (element instanceof LdifModSpec) {
                LdifModSpec modSpec = (LdifModSpec)element;
                if (modSpec.isAdd()) {
                    return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_mod_add.gif");
                }
                if (modSpec.isReplace()) {
                    return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_mod_replace.gif");
                }
                if (modSpec.isDelete()) {
                    return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_mod_delete.gif");
                }
                return null;
            }
            if (element instanceof LdifAttrValLine) {
                return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_value.gif");
            }
            return null;
        }
    }

    private static class LdifContentProvider
    implements ITreeContentProvider {
        private LdifContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof LdifFile) {
                LdifFile ldifFile = (LdifFile)element;
                return ldifFile.getRecords();
            }
            if (element instanceof LdifContentRecord) {
                LdifContentRecord record = (LdifContentRecord)element;
                return this.getUniqueAttrValLineArray(record.getAttrVals());
            }
            if (element instanceof LdifChangeAddRecord) {
                LdifChangeAddRecord record = (LdifChangeAddRecord)element;
                return this.getUniqueAttrValLineArray(record.getAttrVals());
            }
            if (element instanceof LdifChangeModifyRecord) {
                LdifChangeModifyRecord record = (LdifChangeModifyRecord)element;
                return record.getModSpecs();
            }
            if (element instanceof LdifChangeModDnRecord) {
                return new Object[0];
            }
            if (element instanceof LdifChangeDeleteRecord) {
                return new Object[0];
            }
            if (element instanceof List && ((List)element).get(0) instanceof LdifAttrValLine) {
                List list = (List)element;
                return list.toArray();
            }
            if (element instanceof LdifModSpec) {
                LdifModSpec modSpec = (LdifModSpec)element;
                return modSpec.getAttrVals();
            }
            return new Object[0];
        }

        private Object[] getUniqueAttrValLineArray(LdifAttrValLine[] lines) {
            LinkedHashMap uniqueAttrMap = new LinkedHashMap();
            for (int i = 0; i < lines.length; ++i) {
                if (!uniqueAttrMap.containsKey(lines[i].getUnfoldedAttributeDescription())) {
                    uniqueAttrMap.put(lines[i].getUnfoldedAttributeDescription(), new ArrayList());
                }
                ((List)uniqueAttrMap.get(lines[i].getUnfoldedAttributeDescription())).add(lines[i]);
            }
            return uniqueAttrMap.values().toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null && this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

