/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor;

import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExecuteLdifRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifeditor.editor.LdifEditor;
import org.apache.directory.studio.ldifeditor.editor.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;

public class ExecuteLdifAction
extends Action {
    private LdifEditor editor;

    public ExecuteLdifAction(LdifEditor editor) {
        super(Messages.getString("ExecuteLdifAction.ExecuteLDIF"), LdifEditorActivator.getDefault().getImageDescriptor("resources/icons/execute.gif"));
        super.setToolTipText(Messages.getString("ExecuteLdifAction.ExecuteLDIF"));
        this.editor = editor;
    }

    public void run() {
        IBrowserConnection connection = this.editor.getConnection();
        String ldif = this.editor.getLdifModel().toRawString();
        IPreferenceStore preferenceStore = LdifEditorActivator.getDefault().getPreferenceStore();
        boolean updateIfEntryExistsButton = preferenceStore.getBoolean("ldifEditorOptionsUpdateIfEntryExists");
        boolean continueOnErrorButton = preferenceStore.getBoolean("ldifEditorOptionsContinueOnError");
        ExecuteLdifRunnable runnable = new ExecuteLdifRunnable(connection, ldif, updateIfEntryExistsButton, continueOnErrorButton);
        StudioBrowserJob job = new StudioBrowserJob(new StudioRunnableWithProgress[]{runnable});
        job.execute();
    }

    public boolean isEnabled() {
        return this.editor != null && this.editor.getConnection() != null;
    }
}

