/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserCategory;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserEntryPage;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserSearchResultPage;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Bookmark;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.apache.directory.studio.ldapbrowser.ui.wizards.NewBookmarkMainWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewBookmarkWizard
extends Wizard
implements INewWizard {
    private NewBookmarkMainWizardPage mainPage;
    private IEntry selectedEntry;

    public NewBookmarkWizard() {
        this.setWindowTitle(Messages.getString("NewBookmarkWizard.NewBookmark"));
        this.setNeedsProgressMonitor(false);
    }

    public static String getId() {
        return BrowserUIConstants.WIZARD_NEW_BOOKMARK;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object o = selection.getFirstElement();
        this.selectedEntry = o instanceof IEntry ? (IEntry)o : (o instanceof ISearchResult ? ((ISearchResult)o).getEntry() : (o instanceof IBookmark ? ((IBookmark)o).getEntry() : (o instanceof IAttribute ? ((IAttribute)o).getEntry() : (o instanceof IValue ? ((IValue)o).getAttribute().getEntry() : (o instanceof IBrowserConnection ? ((IBrowserConnection)o).getRootDSE() : (o instanceof ISearch ? ((ISearch)o).getBrowserConnection().getRootDSE() : (o instanceof BrowserCategory ? ((BrowserCategory)o).getParent().getRootDSE() : (o instanceof BrowserSearchResultPage ? ((BrowserSearchResultPage)o).getSearch().getBrowserConnection().getRootDSE() : (o instanceof BrowserEntryPage ? ((BrowserEntryPage)o).getEntry() : null)))))))));
    }

    public void addPages() {
        if (this.selectedEntry != null) {
            this.mainPage = new NewBookmarkMainWizardPage(NewBookmarkMainWizardPage.class.getName(), this.selectedEntry, this);
            this.addPage((IWizardPage)this.mainPage);
        } else {
            DummyWizardPage page = new DummyWizardPage();
            this.addPage((IWizardPage)page);
        }
    }

    public boolean performFinish() {
        if (this.selectedEntry != null) {
            String name = this.mainPage.getBookmarkName();
            LdapDN dn = this.mainPage.getBookmarkDn();
            Bookmark bookmark = new Bookmark(this.selectedEntry.getBrowserConnection(), dn, name);
            this.selectedEntry.getBrowserConnection().getBookmarkManager().addBookmark((IBookmark)bookmark);
        }
        this.mainPage.saveDialogSettings();
        return true;
    }

    class DummyWizardPage
    extends WizardPage {
        protected DummyWizardPage() {
            super("");
            this.setTitle(Messages.getString("NewBookmarkWizard.NoEntrySelected"));
            this.setDescription(Messages.getString("NewBookmarkWizard.InOrderToUse"));
            this.setPageComplete(true);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, false);
            composite.setLayout((Layout)gl);
            composite.setLayoutData((Object)new GridData(1808));
            this.setControl((Control)composite);
        }
    }
}

