/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.EntryWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.apache.directory.studio.ldapbrowser.ui.wizards.NewBookmarkWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewBookmarkMainWizardPage
extends WizardPage
implements WidgetModifyListener {
    private IEntry entry;
    private Text bookmarkNameText;
    private EntryWidget bookmarkEntryWidget;

    public NewBookmarkMainWizardPage(String pageName, IEntry entry, NewBookmarkWizard wizard) {
        super(pageName);
        this.setTitle(Messages.getString("NewBookmarkMainWizardPage.NewBookmark"));
        this.setDescription(Messages.getString("NewBookmarkMainWizardPage.EnterNewBookmark"));
        this.setPageComplete(false);
        this.entry = entry;
    }

    public void dispose() {
        super.dispose();
        this.bookmarkEntryWidget.removeWidgetModifyListener((WidgetModifyListener)this);
    }

    private void validate() {
        if (this.bookmarkNameText != null && !this.bookmarkNameText.isDisposed()) {
            this.setPageComplete(this.bookmarkEntryWidget.getDn() != null && !"".equals(this.bookmarkNameText.getText()));
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validate();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        Composite innerComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)innerComposite, (String)Messages.getString("NewBookmarkMainWizardPage.BookmarkName"), (int)1);
        this.bookmarkNameText = BaseWidgetUtils.createText((Composite)innerComposite, (String)this.entry.getDn().getUpName(), (int)2);
        this.bookmarkNameText.setFocus();
        this.bookmarkNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBookmarkMainWizardPage.this.validate();
            }
        });
        BaseWidgetUtils.createLabel((Composite)innerComposite, (String)Messages.getString("NewBookmarkMainWizardPage.BookmarkDN"), (int)1);
        this.bookmarkEntryWidget = new EntryWidget();
        this.bookmarkEntryWidget.addWidgetModifyListener((WidgetModifyListener)this);
        this.bookmarkEntryWidget.createWidget(innerComposite);
        this.bookmarkEntryWidget.setInput(this.entry.getBrowserConnection(), this.entry.getDn());
        this.setControl((Control)composite);
    }

    public void widgetModified(WidgetModifyEvent event) {
        this.validate();
    }

    public LdapDN getBookmarkDn() {
        return this.bookmarkEntryWidget.getDn();
    }

    public String getBookmarkName() {
        return this.bookmarkNameText.getText();
    }

    public void saveDialogSettings() {
        this.bookmarkEntryWidget.saveDialogSettings();
    }
}

