/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.File;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.FileBrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.BrowserConnectionWidget;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ImportLdifWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class ImportLdifMainWizardPage
extends WizardPage {
    public static final String CONTINUE_ON_ERROR_DIALOGSETTING_KEY = ImportLdifMainWizardPage.class.getName() + ".continueOnError";
    public static final String UPDATE_IF_ENTRY_EXISTS_DIALOGSETTING_KEY = ImportLdifMainWizardPage.class.getName() + ".updateIfEntryExists";
    private static final String[] EXTENSIONS = new String[]{"*.ldif", "*.*"};
    private ImportLdifWizard wizard;
    private FileBrowserWidget ldifFileBrowserWidget;
    private BrowserConnectionWidget browserConnectionWidget;
    private Button enableLoggingButton;
    private Button useDefaultLogfileButton;
    private Button useCustomLogfileButton;
    private String customLogfileName;
    private FileBrowserWidget logFileBrowserWidget;
    private Button overwriteLogfileButton;
    private Button updateIfEntryExistsButton;
    private Button continueOnErrorButton;

    public ImportLdifMainWizardPage(String pageName, ImportLdifWizard wizard) {
        super(pageName);
        this.setTitle(Messages.getString("ImportLdifMainWizardPage.LDIFImport"));
        this.setDescription(Messages.getString("ImportLdifMainWizardPage.PleaseSelectConnectionAndLDIF"));
        this.setImageDescriptor(BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/import_ldif_wizard.gif"));
        this.setPageComplete(false);
        this.wizard = wizard;
    }

    private void validate() {
        boolean ok = true;
        File ldifFile = new File(this.ldifFileBrowserWidget.getFilename());
        if ("".equals(this.ldifFileBrowserWidget.getFilename())) {
            this.setErrorMessage(null);
            ok = false;
        } else if (!ldifFile.isFile() || !ldifFile.exists()) {
            this.setErrorMessage(Messages.getString("ImportLdifMainWizardPage.ErrorSelectedLDIFNotExist"));
            ok = false;
        } else if (!ldifFile.canRead()) {
            this.setErrorMessage(Messages.getString("ImportLdifMainWizardPage.ErrorSelectedLDIFNotReadable"));
            ok = false;
        } else if (this.enableLoggingButton.getSelection()) {
            File logFile = new File(this.logFileBrowserWidget.getFilename());
            File logFileDirectory = logFile.getParentFile();
            if (logFile.equals(ldifFile)) {
                this.setErrorMessage(Messages.getString("ImportLdifMainWizardPage.ErrorLDIFAndLogEqual"));
                ok = false;
            } else if (logFile.isDirectory()) {
                this.setErrorMessage(Messages.getString("ImportLdifMainWizardPage.ErrorSelectedLogFileNotFile"));
                ok = false;
            } else if (logFile.exists() && !this.overwriteLogfileButton.getSelection()) {
                this.setErrorMessage(Messages.getString("ImportLdifMainWizardPage.ErrorSelectedLogFileExist"));
                ok = false;
            } else if (logFile.exists() && !logFile.canWrite()) {
                this.setErrorMessage(Messages.getString("ImportLdifMainWizardPage.ErrorSelectedLogFileNotWritable"));
                ok = false;
            } else if (logFile.getParentFile() == null) {
                this.setErrorMessage(Messages.getString("ImportLdifMainWizardPage.ErrorSelectedLogFileDirectoryNotWritable"));
                ok = false;
            } else if (!(logFile.exists() || logFileDirectory != null && logFileDirectory.canWrite())) {
                this.setErrorMessage(Messages.getString("ImportLdifMainWizardPage.ErrorSelectedLogFileDirectoryNotWritable"));
                ok = false;
            }
        }
        if (this.wizard.getImportConnection() == null) {
            ok = false;
        }
        if (ok) {
            this.setErrorMessage(null);
        }
        this.setPageComplete(ok);
        this.getContainer().updateButtons();
    }

    public void createControl(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("ImportLdifMainWizardPage.LDIFFile"), (int)1);
        this.ldifFileBrowserWidget = new FileBrowserWidget(Messages.getString("ImportLdifMainWizardPage.SelectLDIFFile"), EXTENSIONS, 4096);
        this.ldifFileBrowserWidget.createWidget(composite);
        this.ldifFileBrowserWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                ImportLdifMainWizardPage.this.wizard.setLdifFilename(ImportLdifMainWizardPage.this.ldifFileBrowserWidget.getFilename());
                if (ImportLdifMainWizardPage.this.useDefaultLogfileButton.getSelection()) {
                    ImportLdifMainWizardPage.this.logFileBrowserWidget.setFilename(ImportLdifMainWizardPage.this.ldifFileBrowserWidget.getFilename() + ".log");
                }
                ImportLdifMainWizardPage.this.validate();
            }
        });
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("ImportLdifMainWizardPage.ImportTo"), (int)1);
        this.browserConnectionWidget = new BrowserConnectionWidget(this.wizard.getImportConnection());
        this.browserConnectionWidget.createWidget(composite);
        this.browserConnectionWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                ImportLdifMainWizardPage.this.wizard.setImportConnection(ImportLdifMainWizardPage.this.browserConnectionWidget.getBrowserConnection());
                ImportLdifMainWizardPage.this.validate();
            }
        });
        Composite loggingOuterComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)3);
        Group loggingGroup = BaseWidgetUtils.createGroup((Composite)loggingOuterComposite, (String)Messages.getString("ImportLdifMainWizardPage.Logging"), (int)1);
        Composite loggingContainer = BaseWidgetUtils.createColumnContainer((Composite)loggingGroup, (int)3, (int)1);
        this.enableLoggingButton = BaseWidgetUtils.createCheckbox((Composite)loggingContainer, (String)Messages.getString("ImportLdifMainWizardPage.EnableLogging"), (int)3);
        this.enableLoggingButton.setSelection(true);
        this.wizard.setEnableLogging(this.enableLoggingButton.getSelection());
        this.enableLoggingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportLdifMainWizardPage.this.wizard.setEnableLogging(ImportLdifMainWizardPage.this.enableLoggingButton.getSelection());
                ImportLdifMainWizardPage.this.useDefaultLogfileButton.setEnabled(ImportLdifMainWizardPage.this.enableLoggingButton.getSelection());
                ImportLdifMainWizardPage.this.useCustomLogfileButton.setEnabled(ImportLdifMainWizardPage.this.enableLoggingButton.getSelection());
                ImportLdifMainWizardPage.this.logFileBrowserWidget.setEnabled(ImportLdifMainWizardPage.this.enableLoggingButton.getSelection() && ImportLdifMainWizardPage.this.useCustomLogfileButton.getSelection());
                ImportLdifMainWizardPage.this.overwriteLogfileButton.setEnabled(ImportLdifMainWizardPage.this.enableLoggingButton.getSelection());
                ImportLdifMainWizardPage.this.validate();
            }
        });
        BaseWidgetUtils.createRadioIndent((Composite)loggingContainer, (int)1);
        this.useDefaultLogfileButton = BaseWidgetUtils.createRadiobutton((Composite)loggingContainer, (String)Messages.getString("ImportLdifMainWizardPage.UseDefaultLogFile"), (int)2);
        this.useDefaultLogfileButton.setSelection(true);
        this.useDefaultLogfileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String temp = ImportLdifMainWizardPage.this.customLogfileName;
                ImportLdifMainWizardPage.this.logFileBrowserWidget.setFilename(ImportLdifMainWizardPage.this.ldifFileBrowserWidget.getFilename() + ".log");
                ImportLdifMainWizardPage.this.logFileBrowserWidget.setEnabled(false);
                ImportLdifMainWizardPage.this.customLogfileName = temp;
                ImportLdifMainWizardPage.this.validate();
            }
        });
        BaseWidgetUtils.createRadioIndent((Composite)loggingContainer, (int)1);
        this.useCustomLogfileButton = BaseWidgetUtils.createRadiobutton((Composite)loggingContainer, (String)Messages.getString("ImportLdifMainWizardPage.UseCustomLogFile"), (int)2);
        this.useCustomLogfileButton.setSelection(false);
        this.useCustomLogfileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportLdifMainWizardPage.this.logFileBrowserWidget.setFilename(ImportLdifMainWizardPage.this.customLogfileName != null ? ImportLdifMainWizardPage.this.customLogfileName : "");
                ImportLdifMainWizardPage.this.logFileBrowserWidget.setEnabled(true);
                ImportLdifMainWizardPage.this.validate();
            }
        });
        BaseWidgetUtils.createRadioIndent((Composite)loggingContainer, (int)1);
        this.logFileBrowserWidget = new FileBrowserWidget(Messages.getString("ImportLdifMainWizardPage.SelectLogFile"), null, 8192);
        this.logFileBrowserWidget.createWidget(loggingContainer);
        this.logFileBrowserWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                ImportLdifMainWizardPage.this.customLogfileName = ImportLdifMainWizardPage.this.logFileBrowserWidget.getFilename();
                ImportLdifMainWizardPage.this.wizard.setLogFilename(ImportLdifMainWizardPage.this.customLogfileName);
                ImportLdifMainWizardPage.this.validate();
            }
        });
        this.logFileBrowserWidget.setEnabled(false);
        BaseWidgetUtils.createRadioIndent((Composite)loggingContainer, (int)1);
        this.overwriteLogfileButton = BaseWidgetUtils.createCheckbox((Composite)loggingContainer, (String)Messages.getString("ImportLdifMainWizardPage.OverwriteExistingLogFile"), (int)2);
        this.overwriteLogfileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportLdifMainWizardPage.this.validate();
            }
        });
        Composite optionsOuterComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)3);
        Group optionsGroup = BaseWidgetUtils.createGroup((Composite)optionsOuterComposite, (String)Messages.getString("ImportLdifMainWizardPage.Options"), (int)1);
        Composite optionsContainer = BaseWidgetUtils.createColumnContainer((Composite)optionsGroup, (int)3, (int)1);
        this.updateIfEntryExistsButton = BaseWidgetUtils.createCheckbox((Composite)optionsContainer, (String)Messages.getString("ImportLdifMainWizardPage.UpdateExistingEntires"), (int)3);
        this.updateIfEntryExistsButton.setToolTipText(Messages.getString("ImportLdifMainWizardPage.OptionsAppliesForLdif"));
        if (BrowserUIPlugin.getDefault().getDialogSettings().get(UPDATE_IF_ENTRY_EXISTS_DIALOGSETTING_KEY) == null) {
            BrowserUIPlugin.getDefault().getDialogSettings().put(UPDATE_IF_ENTRY_EXISTS_DIALOGSETTING_KEY, false);
        }
        this.updateIfEntryExistsButton.setSelection(BrowserUIPlugin.getDefault().getDialogSettings().getBoolean(UPDATE_IF_ENTRY_EXISTS_DIALOGSETTING_KEY));
        this.wizard.setUpdateIfEntryExists(this.updateIfEntryExistsButton.getSelection());
        this.updateIfEntryExistsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportLdifMainWizardPage.this.wizard.setUpdateIfEntryExists(ImportLdifMainWizardPage.this.updateIfEntryExistsButton.getSelection());
                ImportLdifMainWizardPage.this.validate();
            }
        });
        this.continueOnErrorButton = BaseWidgetUtils.createCheckbox((Composite)optionsContainer, (String)Messages.getString("ImportLdifMainWizardPage.ContinueOnError"), (int)3);
        if (BrowserUIPlugin.getDefault().getDialogSettings().get(CONTINUE_ON_ERROR_DIALOGSETTING_KEY) == null) {
            BrowserUIPlugin.getDefault().getDialogSettings().put(CONTINUE_ON_ERROR_DIALOGSETTING_KEY, false);
        }
        this.continueOnErrorButton.setSelection(BrowserUIPlugin.getDefault().getDialogSettings().getBoolean(CONTINUE_ON_ERROR_DIALOGSETTING_KEY));
        this.wizard.setContinueOnError(this.continueOnErrorButton.getSelection());
        this.continueOnErrorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportLdifMainWizardPage.this.wizard.setContinueOnError(ImportLdifMainWizardPage.this.continueOnErrorButton.getSelection());
                ImportLdifMainWizardPage.this.validate();
            }
        });
        this.setControl((Control)composite);
    }

    public void saveDialogSettings() {
        this.ldifFileBrowserWidget.saveDialogSettings();
        BrowserUIPlugin.getDefault().getDialogSettings().put(UPDATE_IF_ENTRY_EXISTS_DIALOGSETTING_KEY, this.updateIfEntryExistsButton.getSelection());
        BrowserUIPlugin.getDefault().getDialogSettings().put(CONTINUE_ON_ERROR_DIALOGSETTING_KEY, this.continueOnErrorButton.getSelection());
    }
}

