/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.File;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.FileBrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.BrowserConnectionWidget;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ImportDsmlWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class ImportDsmlMainWizardPage
extends WizardPage {
    private ImportDsmlWizard wizard;
    private static final String[] EXTENSIONS = new String[]{"*.xml", "*.*"};
    private FileBrowserWidget dsmlFileBrowserWidget;
    private BrowserConnectionWidget browserConnectionWidget;
    private Button saveResponseButton;
    private Button useDefaultResponseFileButton;
    private Button useCustomResponseFileButton;
    private FileBrowserWidget responseFileBrowserWidget;
    private Button overwriteResponseFileButton;
    private String customResponseFileName;

    public ImportDsmlMainWizardPage(String pageName, ImportDsmlWizard wizard) {
        super(pageName);
        this.setTitle(wizard.getWindowTitle());
        this.setDescription(Messages.getString("ImportDsmlMainWizardPage.SelectConnectionAndDSMLFile"));
        this.setImageDescriptor(BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/import_dsml_wizard.gif"));
        this.setPageComplete(false);
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("ImportDsmlMainWizardPage.DSMLFile"), (int)1);
        this.dsmlFileBrowserWidget = new FileBrowserWidget(Messages.getString("ImportDsmlMainWizardPage.SelectDSMLFile"), EXTENSIONS, 4096);
        this.dsmlFileBrowserWidget.createWidget(composite);
        this.dsmlFileBrowserWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                ImportDsmlMainWizardPage.this.wizard.setDsmlFilename(ImportDsmlMainWizardPage.this.dsmlFileBrowserWidget.getFilename());
                if (ImportDsmlMainWizardPage.this.useDefaultResponseFileButton.getSelection()) {
                    ImportDsmlMainWizardPage.this.responseFileBrowserWidget.setFilename(ImportDsmlMainWizardPage.this.dsmlFileBrowserWidget.getFilename() + ".response.xml");
                }
                ImportDsmlMainWizardPage.this.validate();
            }
        });
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("ImportDsmlMainWizardPage.ImportTo"), (int)1);
        this.browserConnectionWidget = new BrowserConnectionWidget(this.wizard.getImportConnection());
        this.browserConnectionWidget.createWidget(composite);
        this.browserConnectionWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                ImportDsmlMainWizardPage.this.wizard.setImportConnection(ImportDsmlMainWizardPage.this.browserConnectionWidget.getBrowserConnection());
                ImportDsmlMainWizardPage.this.validate();
            }
        });
        Composite responseOuterComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)3);
        Group responseGroup = BaseWidgetUtils.createGroup((Composite)responseOuterComposite, (String)Messages.getString("ImportDsmlMainWizardPage.Response"), (int)1);
        Composite responseContainer = BaseWidgetUtils.createColumnContainer((Composite)responseGroup, (int)3, (int)1);
        this.saveResponseButton = BaseWidgetUtils.createCheckbox((Composite)responseContainer, (String)Messages.getString("ImportDsmlMainWizardPage.SaveResponse"), (int)3);
        this.saveResponseButton.setSelection(true);
        this.wizard.setSaveResponse(this.saveResponseButton.getSelection());
        this.saveResponseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportDsmlMainWizardPage.this.wizard.setSaveResponse(ImportDsmlMainWizardPage.this.saveResponseButton.getSelection());
                ImportDsmlMainWizardPage.this.useDefaultResponseFileButton.setEnabled(ImportDsmlMainWizardPage.this.saveResponseButton.getSelection());
                ImportDsmlMainWizardPage.this.useCustomResponseFileButton.setEnabled(ImportDsmlMainWizardPage.this.saveResponseButton.getSelection());
                ImportDsmlMainWizardPage.this.responseFileBrowserWidget.setEnabled(ImportDsmlMainWizardPage.this.saveResponseButton.getSelection() && ImportDsmlMainWizardPage.this.useCustomResponseFileButton.getSelection());
                ImportDsmlMainWizardPage.this.overwriteResponseFileButton.setEnabled(ImportDsmlMainWizardPage.this.saveResponseButton.getSelection());
                ImportDsmlMainWizardPage.this.validate();
            }
        });
        BaseWidgetUtils.createRadioIndent((Composite)responseContainer, (int)1);
        this.useDefaultResponseFileButton = BaseWidgetUtils.createRadiobutton((Composite)responseContainer, (String)Messages.getString("ImportDsmlMainWizardPage.UseDefaultResponse"), (int)2);
        this.useDefaultResponseFileButton.setSelection(true);
        this.useDefaultResponseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String temp = ImportDsmlMainWizardPage.this.customResponseFileName;
                ImportDsmlMainWizardPage.this.responseFileBrowserWidget.setFilename(ImportDsmlMainWizardPage.this.dsmlFileBrowserWidget.getFilename() + ".response.xml");
                ImportDsmlMainWizardPage.this.responseFileBrowserWidget.setEnabled(false);
                ImportDsmlMainWizardPage.this.customResponseFileName = temp;
                ImportDsmlMainWizardPage.this.validate();
            }
        });
        BaseWidgetUtils.createRadioIndent((Composite)responseContainer, (int)1);
        this.useCustomResponseFileButton = BaseWidgetUtils.createRadiobutton((Composite)responseContainer, (String)Messages.getString("ImportDsmlMainWizardPage.UseCustomResponse"), (int)2);
        this.useCustomResponseFileButton.setSelection(false);
        this.useCustomResponseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportDsmlMainWizardPage.this.responseFileBrowserWidget.setFilename(ImportDsmlMainWizardPage.this.customResponseFileName != null ? ImportDsmlMainWizardPage.this.customResponseFileName : "");
                ImportDsmlMainWizardPage.this.responseFileBrowserWidget.setEnabled(true);
                ImportDsmlMainWizardPage.this.validate();
            }
        });
        BaseWidgetUtils.createRadioIndent((Composite)responseContainer, (int)1);
        this.responseFileBrowserWidget = new FileBrowserWidget(Messages.getString("ImportDsmlMainWizardPage.SelectSaveFile"), null, 8192);
        this.responseFileBrowserWidget.createWidget(responseContainer);
        this.responseFileBrowserWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                ImportDsmlMainWizardPage.this.customResponseFileName = ImportDsmlMainWizardPage.this.responseFileBrowserWidget.getFilename();
                ImportDsmlMainWizardPage.this.wizard.setResponseFilename(ImportDsmlMainWizardPage.this.customResponseFileName);
                ImportDsmlMainWizardPage.this.validate();
            }
        });
        this.responseFileBrowserWidget.setEnabled(false);
        BaseWidgetUtils.createRadioIndent((Composite)responseContainer, (int)1);
        this.overwriteResponseFileButton = BaseWidgetUtils.createCheckbox((Composite)responseContainer, (String)Messages.getString("ImportDsmlMainWizardPage.OverwriteExistingResponseFile"), (int)2);
        this.overwriteResponseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportDsmlMainWizardPage.this.validate();
            }
        });
        this.setControl((Control)composite);
    }

    private void validate() {
        boolean ok = true;
        File dsmlFile = new File(this.dsmlFileBrowserWidget.getFilename());
        if ("".equals(this.dsmlFileBrowserWidget.getFilename())) {
            this.setErrorMessage(null);
            ok = false;
        } else if (!dsmlFile.isFile() || !dsmlFile.exists()) {
            this.setErrorMessage(Messages.getString("ImportDsmlMainWizardPage.ErrorSelectedDSMLNotExist"));
            ok = false;
        } else if (!dsmlFile.canRead()) {
            this.setErrorMessage(Messages.getString("ImportDsmlMainWizardPage.ErrorSelectedDSMLNotReadable"));
            ok = false;
        } else if (this.saveResponseButton.getSelection()) {
            File responseFile = new File(this.responseFileBrowserWidget.getFilename());
            File responseFileDirectory = responseFile.getParentFile();
            if (responseFile.equals(dsmlFile)) {
                this.setErrorMessage(Messages.getString("ImportDsmlMainWizardPage.ErrorDSMLFileAndResponseFileEqual"));
                ok = false;
            } else if (responseFile.isDirectory()) {
                this.setErrorMessage(Messages.getString("ImportDsmlMainWizardPage.ErrorSelectedResponseFileNotFile"));
                ok = false;
            } else if (responseFile.exists() && !this.overwriteResponseFileButton.getSelection()) {
                this.setErrorMessage(Messages.getString("ImportDsmlMainWizardPage.ErrorSelecedResponseFileExist"));
                ok = false;
            } else if (responseFile.exists() && !responseFile.canWrite()) {
                this.setErrorMessage(Messages.getString("ImportDsmlMainWizardPage.ErrorSelectedResponseFileNotWritable"));
                ok = false;
            } else if (responseFile.getParentFile() == null) {
                this.setErrorMessage(Messages.getString("ImportDsmlMainWizardPage.ErrorSelectedResponseFileDirectoryNotWritable"));
                ok = false;
            } else if (!(responseFile.exists() || responseFileDirectory != null && responseFileDirectory.canWrite())) {
                this.setErrorMessage(Messages.getString("ImportDsmlMainWizardPage.ErrorSelectedResponseFileDirectoryNotWritable"));
                ok = false;
            }
        }
        if (this.wizard.getImportConnection() == null || this.browserConnectionWidget.getBrowserConnection() == null) {
            this.setErrorMessage(Messages.getString("ImportDsmlMainWizardPage.PleaseSelectConnection"));
            ok = false;
        }
        if (ok) {
            this.setErrorMessage(null);
        }
        this.setPageComplete(ok);
        this.getContainer().updateButtons();
    }

    public void saveDialogSettings() {
        this.dsmlFileBrowserWidget.saveDialogSettings();
    }
}

