/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import org.apache.directory.studio.ldapbrowser.core.jobs.ExportDsmlJob;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportBaseWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportDsmlFromWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportDsmlToWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ExportDsmlWizard
extends ExportBaseWizard {
    public static final String WIZARD_TITLE = Messages.getString("ExportDsmlWizard.DSMLExport");
    private ExportDsmlFromWizardPage fromPage;
    private ExportDsmlToWizardPage toPage;
    private ExportDsmlWizardSaveAsType saveAsType = ExportDsmlWizardSaveAsType.RESPONSE;

    public ExportDsmlWizard() {
        super(WIZARD_TITLE);
    }

    public static String getId() {
        return BrowserUIConstants.WIZARD_EXPORT_DSML;
    }

    public void addPages() {
        this.fromPage = new ExportDsmlFromWizardPage(ExportDsmlFromWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.fromPage);
        this.toPage = new ExportDsmlToWizardPage(ExportDsmlToWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.toPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fromPage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_dsmlexport_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.toPage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_dsmlexport_wizard");
    }

    public boolean performFinish() {
        this.fromPage.saveDialogSettings();
        this.toPage.saveDialogSettings();
        switch (this.saveAsType) {
            case RESPONSE: {
                new ExportDsmlJob(this.exportFilename, this.search.getBrowserConnection(), this.search.getSearchParameter(), ExportDsmlJob.ExportDsmlJobType.RESPONSE).execute();
                break;
            }
            case REQUEST: {
                new ExportDsmlJob(this.exportFilename, this.search.getBrowserConnection(), this.search.getSearchParameter(), ExportDsmlJob.ExportDsmlJobType.REQUEST).execute();
            }
        }
        return true;
    }

    public ExportDsmlWizardSaveAsType getSaveAsType() {
        return this.saveAsType;
    }

    public void setSaveAsType(ExportDsmlWizardSaveAsType saveAsType) {
        this.saveAsType = saveAsType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExportDsmlWizardSaveAsType {
        RESPONSE,
        REQUEST;

    }
}

