/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationApplyOnWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationFinishWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationLdifWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationModifyWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationTypeWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.apache.directory.studio.ldifeditor.editor.LdifEditor;
import org.apache.directory.studio.ldifeditor.editor.NonExistingLdifEditorInput;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class BatchOperationWizard
extends Wizard
implements INewWizard {
    private IBrowserConnection connection;
    private BatchOperationApplyOnWizardPage applyOnPage;
    private BatchOperationTypeWizardPage typePage;
    private BatchOperationLdifWizardPage ldifPage;
    private BatchOperationModifyWizardPage modifyPage;
    private BatchOperationFinishWizardPage finishPage;

    public BatchOperationWizard() {
        super.setWindowTitle(Messages.getString("BatchOperationWizard.BatchOperation"));
        super.setNeedsProgressMonitor(true);
    }

    public static String getId() {
        return BrowserUIConstants.WIZARD_BATCH_OPERATION;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        Connection[] connections = BrowserSelectionUtils.getConnections((ISelection)selection);
        ISearch[] searches = BrowserSelectionUtils.getSearches((ISelection)selection);
        IEntry[] entries = BrowserSelectionUtils.getEntries((ISelection)selection);
        ISearchResult[] searchResults = BrowserSelectionUtils.getSearchResults((ISelection)selection);
        IBookmark[] bookmarks = BrowserSelectionUtils.getBookmarks((ISelection)selection);
        IAttribute[] attributes = BrowserSelectionUtils.getAttributes((ISelection)selection);
        IValue[] values = BrowserSelectionUtils.getValues((ISelection)selection);
        if (connections.length > 0 && connections[0].getJNDIConnectionWrapper().isConnected() || searches.length + entries.length + searchResults.length + bookmarks.length + attributes.length + values.length > 0) {
            ISearch search = BrowserSelectionUtils.getExampleSearch((ISelection)selection);
            search.setName(null);
            this.connection = search.getBrowserConnection();
            this.applyOnPage = new BatchOperationApplyOnWizardPage(BatchOperationApplyOnWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.applyOnPage);
            this.typePage = new BatchOperationTypeWizardPage(BatchOperationTypeWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.typePage);
            this.ldifPage = new BatchOperationLdifWizardPage(BatchOperationLdifWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.ldifPage);
            this.modifyPage = new BatchOperationModifyWizardPage(BatchOperationModifyWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.modifyPage);
            this.finishPage = new BatchOperationFinishWizardPage(BatchOperationFinishWizardPage.class.getName(), this);
            this.addPage((IWizardPage)this.finishPage);
        } else {
            DummyWizardPage page = new DummyWizardPage();
            this.addPage((IWizardPage)page);
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.applyOnPage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_batchoperation_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.typePage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_batchoperation_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.ldifPage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_batchoperation_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.modifyPage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_batchoperation_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.finishPage.getControl(), BrowserUIConstants.PLUGIN_ID + "." + "tools_batchoperation_wizard");
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.applyOnPage != null) {
            if (page == this.applyOnPage) {
                return this.typePage;
            }
            if (page == this.typePage && this.typePage.getOperationType() == 2) {
                return this.ldifPage;
            }
            if (page == this.typePage && this.typePage.getOperationType() == 0) {
                return this.modifyPage;
            }
            if (page == this.typePage && this.typePage.getOperationType() == 1) {
                return this.finishPage;
            }
            if (page == this.modifyPage) {
                return this.finishPage;
            }
            if (page == this.ldifPage) {
                return this.finishPage;
            }
        }
        return null;
    }

    public boolean canFinish() {
        if (this.applyOnPage != null) {
            if (!this.applyOnPage.isPageComplete()) {
                return false;
            }
            if (!this.typePage.isPageComplete()) {
                return false;
            }
            if (this.typePage.getOperationType() == 2 && !this.ldifPage.isPageComplete()) {
                return false;
            }
            if (this.typePage.getOperationType() == 0 && !this.modifyPage.isPageComplete()) {
                return false;
            }
            if (!this.finishPage.isPageComplete()) {
                return false;
            }
        }
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        if (this.applyOnPage != null) {
            ISearch search;
            LdapDN[] dns;
            this.applyOnPage.saveDialogSettings();
            String ldifFragment = "";
            if (this.typePage.getOperationType() == 2) {
                ldifFragment = this.ldifPage.getLdifFragment();
            } else if (this.typePage.getOperationType() == 0) {
                ldifFragment = this.modifyPage.getLdifFragment();
            }
            if (this.typePage.getOperationType() == 1) {
                ldifFragment = "changetype: delete" + BrowserCoreConstants.LINE_SEPARATOR;
            }
            if ((dns = this.applyOnPage.getApplyOnDns()) == null && this.applyOnPage.getApplyOnSearch() != null && (search = this.applyOnPage.getApplyOnSearch()).getBrowserConnection() != null) {
                search.setSearchResults(null);
                SearchRunnable runnable = new SearchRunnable(new ISearch[]{search});
                IStatus status = RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, (IRunnableContext)this.getContainer(), (boolean)true);
                if (status.isOK()) {
                    ISearchResult[] srs = search.getSearchResults();
                    dns = new LdapDN[srs.length];
                    for (int i = 0; i < srs.length; ++i) {
                        dns[i] = srs[i].getDn();
                    }
                }
            }
            if (dns != null) {
                StringBuffer ldif = new StringBuffer();
                for (int i = 0; i < dns.length; ++i) {
                    ldif.append("dn: ");
                    ldif.append(dns[i].getUpName());
                    ldif.append(BrowserCoreConstants.LINE_SEPARATOR);
                    ldif.append(ldifFragment);
                    ldif.append(BrowserCoreConstants.LINE_SEPARATOR);
                }
                if (this.finishPage.getExecutionMethod() == 0) {
                    NonExistingLdifEditorInput input = new NonExistingLdifEditorInput();
                    String editorId = LdifEditor.getId();
                    try {
                        IDocument document;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IWorkbenchPage page = window.getActivePage();
                        IEditorPart editor = page.openEditor((IEditorInput)input, editorId);
                        IDocumentProvider documentProvider = ((LdifEditor)editor).getDocumentProvider();
                        if (documentProvider != null && input != null && (document = documentProvider.getDocument((Object)input)) != null) {
                            document.set(ldif.toString());
                        }
                    }
                    catch (PartInitException e) {
                        return false;
                    }
                    return true;
                }
                if (this.finishPage.getExecutionMethod() == 1) {
                    // empty if block
                }
            }
            return false;
        }
        return true;
    }

    public BatchOperationTypeWizardPage getTypePage() {
        return this.typePage;
    }

    public IBrowserConnection getConnection() {
        return this.connection;
    }

    class DummyWizardPage
    extends WizardPage {
        protected DummyWizardPage() {
            super("");
            super.setTitle(Messages.getString("BatchOperationWizard.NoConnectionSelected"));
            super.setDescription(Messages.getString("BatchOperationWizard.SelectOPenCollection"));
            super.setPageComplete(true);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, false);
            composite.setLayout((Layout)gl);
            composite.setLayoutData((Object)new GridData(1808));
            this.setControl((Control)composite);
        }
    }
}

