/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.SearchPageWrapper;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class BatchOperationApplyOnWizardPage
extends WizardPage {
    private String[] initCurrentSelectionTexts;
    private LdapDN[][] initCurrentSelectionDns;
    private ISearch initSearch;
    private Button currentSelectionButton;
    private Combo currentSelectionCombo;
    private Button searchButton;
    private SearchPageWrapper spw;

    public BatchOperationApplyOnWizardPage(String pageName, BatchOperationWizard wizard) {
        super(pageName);
        super.setTitle(Messages.getString("BatchOperationApplyOnWizardPage.SelectApplicationEntries"));
        super.setDescription(Messages.getString("BatchOperationApplyOnWizardPage.PleaseSelectEntries"));
        super.setPageComplete(false);
        this.prepareCurrentSelection();
        this.prepareSearch();
    }

    private void validate() {
        this.setPageComplete(this.getApplyOnDns() != null || this.spw.isValid());
        this.setErrorMessage(this.searchButton.getSelection() ? this.spw.getErrorMessage() : null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        Composite applyOnGroup = composite;
        this.currentSelectionButton = BaseWidgetUtils.createRadiobutton((Composite)applyOnGroup, (String)Messages.getString("BatchOperationApplyOnWizardPage.CurrentSelection"), (int)1);
        this.currentSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BatchOperationApplyOnWizardPage.this.enableCurrentSelectionWidgets(BatchOperationApplyOnWizardPage.this.currentSelectionButton.getSelection());
                BatchOperationApplyOnWizardPage.this.validate();
            }
        });
        Composite currentSelectionComposite = BaseWidgetUtils.createColumnContainer((Composite)applyOnGroup, (int)2, (int)1);
        BaseWidgetUtils.createRadioIndent((Composite)currentSelectionComposite, (int)1);
        this.currentSelectionCombo = BaseWidgetUtils.createReadonlyCombo((Composite)currentSelectionComposite, (String[])this.initCurrentSelectionTexts, (int)0, (int)1);
        this.currentSelectionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BatchOperationApplyOnWizardPage.this.validate();
            }
        });
        BaseWidgetUtils.createSpacer((Composite)applyOnGroup, (int)1);
        BaseWidgetUtils.createSpacer((Composite)applyOnGroup, (int)1);
        this.searchButton = BaseWidgetUtils.createRadiobutton((Composite)applyOnGroup, (String)Messages.getString("BatchOperationApplyOnWizardPage.ResultsOfSearch"), (int)1);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BatchOperationApplyOnWizardPage.this.enableSearchWidgets(BatchOperationApplyOnWizardPage.this.searchButton.getSelection());
                BatchOperationApplyOnWizardPage.this.validate();
            }
        });
        Composite searchComposite = BaseWidgetUtils.createColumnContainer((Composite)applyOnGroup, (int)2, (int)1);
        BaseWidgetUtils.createRadioIndent((Composite)searchComposite, (int)1);
        Composite innerSearchComposite = BaseWidgetUtils.createColumnContainer((Composite)searchComposite, (int)3, (int)1);
        this.spw = new SearchPageWrapper(0x6000202);
        this.spw.createContents(innerSearchComposite);
        this.spw.loadFromSearch(this.initSearch);
        this.spw.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                BatchOperationApplyOnWizardPage.this.validate();
            }
        });
        this.currentSelectionButton.setSelection(this.currentSelectionCombo.getItemCount() > 0);
        this.currentSelectionButton.setEnabled(this.currentSelectionCombo.getItemCount() > 0);
        this.searchButton.setSelection(this.currentSelectionCombo.getItemCount() == 0);
        this.enableCurrentSelectionWidgets(this.currentSelectionButton.getSelection());
        this.enableSearchWidgets(this.searchButton.getSelection());
        this.validate();
        this.setControl((Control)composite);
    }

    public LdapDN[] getApplyOnDns() {
        if (this.currentSelectionButton.getSelection()) {
            int index = this.currentSelectionCombo.getSelectionIndex();
            return this.initCurrentSelectionDns[index];
        }
        return null;
    }

    public ISearch getApplyOnSearch() {
        if (this.searchButton.getSelection()) {
            return this.initSearch;
        }
        return null;
    }

    private void enableCurrentSelectionWidgets(boolean b) {
        this.currentSelectionCombo.setEnabled(b);
    }

    private void enableSearchWidgets(boolean b) {
        this.spw.setEnabled(b);
    }

    private void prepareSearch() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        this.initSearch = BrowserSelectionUtils.getExampleSearch((ISelection)selection);
        this.initSearch.setName(null);
        this.initSearch.setReferralsHandlingMethod(Connection.ReferralHandlingMethod.IGNORE);
    }

    private void prepareCurrentSelection() {
        LinkedHashSet<LdapDN> internalDnSet;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        ISearch[] searches = BrowserSelectionUtils.getSearches((ISelection)selection);
        IEntry[] entries = BrowserSelectionUtils.getEntries((ISelection)selection);
        ISearchResult[] searchResults = BrowserSelectionUtils.getSearchResults((ISelection)selection);
        IBookmark[] bookmarks = BrowserSelectionUtils.getBookmarks((ISelection)selection);
        IAttribute[] attributes = BrowserSelectionUtils.getAttributes((ISelection)selection);
        IValue[] values = BrowserSelectionUtils.getValues((ISelection)selection);
        ArrayList<String> textList = new ArrayList<String>();
        ArrayList<LdapDN[]> dnsList = new ArrayList<LdapDN[]>();
        if (attributes.length + values.length > 0) {
            internalDnSet = new LinkedHashSet<LdapDN>();
            for (int v = 0; v < values.length; ++v) {
                if (!values[v].isString()) continue;
                try {
                    LdapDN dn = new LdapDN(values[v].getStringValue());
                    internalDnSet.add(dn);
                    continue;
                }
                catch (InvalidNameException e) {
                    // empty catch block
                }
            }
            for (int a = 0; a < attributes.length; ++a) {
                IValue[] vals = attributes[a].getValues();
                for (int v = 0; v < vals.length; ++v) {
                    if (!vals[v].isString()) continue;
                    try {
                        LdapDN dn = new LdapDN(vals[v].getStringValue());
                        internalDnSet.add(dn);
                        continue;
                    }
                    catch (InvalidNameException e) {
                        // empty catch block
                    }
                }
            }
            if (!internalDnSet.isEmpty()) {
                dnsList.add(internalDnSet.toArray(new LdapDN[internalDnSet.size()]));
                textList.add(NLS.bind((String)Messages.getString("BatchOperationApplyOnWizardPage.DNsOfSelectedAttributes"), (Object[])new Object[]{internalDnSet.size()}));
            }
        }
        if (searches.length == 1 && searches[0].getSearchResults() != null) {
            internalDnSet = new LinkedHashSet();
            ISearchResult[] srs = searches[0].getSearchResults();
            for (int i = 0; i < srs.length; ++i) {
                internalDnSet.add(srs[i].getDn());
            }
            dnsList.add(internalDnSet.toArray(new LdapDN[internalDnSet.size()]));
            textList.add(NLS.bind((String)Messages.getString("BatchOperationApplyOnWizardPage.SearchResultOf"), (Object[])new Object[]{searches[0].getName(), searches[0].getSearchResults().length}));
        }
        if (entries.length + searchResults.length + bookmarks.length > 0) {
            int i;
            internalDnSet = new LinkedHashSet();
            for (i = 0; i < entries.length; ++i) {
                internalDnSet.add(entries[i].getDn());
            }
            for (i = 0; i < searchResults.length; ++i) {
                internalDnSet.add(searchResults[i].getDn());
            }
            for (i = 0; i < bookmarks.length; ++i) {
                internalDnSet.add(bookmarks[i].getDn());
            }
            dnsList.add(internalDnSet.toArray(new LdapDN[internalDnSet.size()]));
            textList.add(NLS.bind((String)Messages.getString("BatchOperationApplyOnWizardPage.SelectedEntries"), (Object[])new Object[]{internalDnSet.size()}));
        }
        this.initCurrentSelectionTexts = textList.toArray(new String[textList.size()]);
        this.initCurrentSelectionDns = (LdapDN[][])dnsList.toArray((T[])new LdapDN[0][0]);
    }

    public void saveDialogSettings() {
        this.spw.saveToSearch(this.initSearch);
    }
}

