/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.connection;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.OpenConnectionsRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.actions.SelectionUtils;
import org.apache.directory.studio.connection.ui.widgets.ConnectionUniversalListener;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserView;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionView;
import org.apache.directory.studio.ldapbrowser.ui.views.modificationlogs.ModificationLogsView;
import org.apache.directory.studio.ldapbrowser.ui.views.searchlogs.SearchLogsView;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ConnectionViewUniversalListener
extends ConnectionUniversalListener {
    protected ConnectionView view;
    private ISelectionChangedListener viewerSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Connection[] connections = SelectionUtils.getConnections((ISelection)event.getSelection());
            if (connections.length == 1) {
                ConnectionViewUniversalListener.this.ensureViewVisible();
            }
        }
    };
    private IDoubleClickListener viewerDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            Connection[] connections = SelectionUtils.getConnections((ISelection)event.getSelection());
            if (connections.length == 1) {
                ConnectionViewUniversalListener.this.toggleConnection(connections[0]);
            }
        }
    };

    public ConnectionViewUniversalListener(ConnectionView view) {
        super(view.getMainWidget().getViewer());
        this.view = view;
        this.viewer.addSelectionChangedListener(this.viewerSelectionListener);
        this.viewer.addDoubleClickListener(this.viewerDoubleClickListener);
    }

    public void dispose() {
        this.view = null;
        super.dispose();
    }

    private void ensureViewVisible() {
        if (this.view != null) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(BrowserView.getId(), null, 2);
            }
            catch (PartInitException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ModificationLogsView.getId(), null, 3);
            }
            catch (PartInitException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(SearchLogsView.getId(), null, 3);
            }
            catch (PartInitException e) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void toggleConnection(Connection connection) {
        if (connection.getJNDIConnectionWrapper().isConnected()) {
            connection.getJNDIConnectionWrapper().disconnect();
        } else {
            new StudioBrowserJob(new StudioRunnableWithProgress[]{new OpenConnectionsRunnable(connection)}).execute();
        }
    }
}

