/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.search;

import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.SearchPageWrapper;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SearchPage
extends DialogPage
implements ISearchPage,
WidgetModifyListener {
    private ISearchPageContainer container;
    private ISearch search;
    private SearchPageWrapper spw;
    private Label errorMessageLabel;

    public static String getId() {
        return BrowserUIConstants.SEARCH_PAGE_LDAP_SEARCH;
    }

    public void dispose() {
        this.spw.removeWidgetModifyListener((WidgetModifyListener)this);
        super.dispose();
    }

    public SearchPage() {
    }

    public SearchPage(String title) {
        super(title);
    }

    public SearchPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public boolean performAction() {
        this.spw.saveToSearch(this.search);
        if (this.search.getBrowserConnection() != null) {
            this.search.getBrowserConnection().getSearchManager().addSearch(this.search);
            return this.spw.performSearch(this.search);
        }
        return false;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public void createControl(Composite parent) {
        this.search = BrowserSelectionUtils.getExampleSearch((ISelection)this.container.getSelection());
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        parent.setLayoutData((Object)gd);
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)3, (int)1);
        this.spw = new SearchPageWrapper(0);
        this.spw.createContents(composite);
        this.spw.loadFromSearch(this.search);
        this.spw.addWidgetModifyListener((WidgetModifyListener)this);
        this.errorMessageLabel = BaseWidgetUtils.createLabel((Composite)parent, (String)"", (int)3);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, BrowserUIConstants.PLUGIN_ID + "." + "tools_search_dialog");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, BrowserUIConstants.PLUGIN_ID + "." + "tools_search_dialog");
        super.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        this.container.setPerformActionEnabled(this.spw.isValid());
        super.setVisible(visible);
    }

    public void widgetModified(WidgetModifyEvent event) {
        this.container.setPerformActionEnabled(this.spw.isValid());
        this.setErrorMessage(this.spw.getErrorMessage());
        this.errorMessageLabel.setText(this.getErrorMessage() != null ? this.getErrorMessage() : "");
    }
}

