/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.perspective;

import org.apache.directory.studio.connection.ui.wizards.NewConnectionWizard;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewContextEntryWizard;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryWizard;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserView;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionView;
import org.apache.directory.studio.ldapbrowser.ui.views.modificationlogs.ModificationLogsView;
import org.apache.directory.studio.ldapbrowser.ui.views.searchlogs.SearchLogsView;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.NewBookmarkWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.NewSearchWizard;
import org.apache.directory.studio.ldifeditor.wizards.NewLdifFileWizard;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class BrowserPerspective
implements IPerspectiveFactory {
    public static String getId() {
        return BrowserUIConstants.PERSPECTIVE_LDAP;
    }

    public void createInitialLayout(IPageLayout layout) {
        this.defineActions(layout);
        this.defineLayout(layout);
        layout.addPerspectiveShortcut(BrowserUIConstants.PERSPECTIVE_SCHEMA_EDITOR);
        layout.addPerspectiveShortcut(BrowserUIConstants.PERSPECTIVE_LDAP);
    }

    private void defineActions(IPageLayout layout) {
        layout.addNewWizardShortcut(NewConnectionWizard.getId());
        layout.addNewWizardShortcut(NewEntryWizard.getId());
        layout.addNewWizardShortcut(NewContextEntryWizard.getId());
        layout.addNewWizardShortcut(NewSearchWizard.getId());
        layout.addNewWizardShortcut(NewBookmarkWizard.getId());
        layout.addNewWizardShortcut(BatchOperationWizard.getId());
        layout.addNewWizardShortcut(NewLdifFileWizard.getId());
        layout.addShowViewShortcut(ConnectionView.getId());
        layout.addShowViewShortcut(BrowserView.getId());
        layout.addShowViewShortcut(ModificationLogsView.getId());
        layout.addShowViewShortcut(SearchLogsView.getId());
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProgressView");
    }

    private void defineLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout browserFolder = layout.createFolder("browserFolder", 1, 0.25f, editorArea);
        browserFolder.addView(BrowserView.getId());
        IFolderLayout connectionFolder = layout.createFolder("connectionFolder", 4, 0.75f, "browserFolder");
        connectionFolder.addView(ConnectionView.getId());
        IFolderLayout outlineFolder = layout.createFolder("outlineFolder", 2, 0.75f, editorArea);
        outlineFolder.addView("org.eclipse.ui.views.ContentOutline");
        IFolderLayout progessFolder = layout.createFolder("progressFolder", 4, 0.75f, "outlineFolder");
        progessFolder.addView("org.eclipse.ui.views.ProgressView");
        IFolderLayout logFolder = layout.createFolder("logFolder", 4, 0.75f, editorArea);
        logFolder.addView(ModificationLogsView.getId());
        logFolder.addView(SearchLogsView.getId());
        logFolder.addPlaceholder("*");
        boolean isIDE = BrowserCommonActivator.isIDEEnvironment();
        if (!isIDE) {
            layout.getViewLayout(BrowserView.getId()).setCloseable(false);
            layout.getViewLayout(ConnectionView.getId()).setCloseable(false);
            layout.getViewLayout("org.eclipse.ui.views.ContentOutline").setCloseable(false);
            layout.getViewLayout("org.eclipse.ui.views.ProgressView").setCloseable(false);
            layout.getViewLayout(ModificationLogsView.getId()).setCloseable(false);
        }
    }
}

