/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.SearchResult;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;

public class SearchResultEditorCursor
extends TableCursor
implements ISelectionProvider,
EntryUpdateListener {
    private TableViewer viewer;
    private List<ISelectionChangedListener> selectionChangesListenerList;
    private ISearchResult referenceCopy;
    private ISearchResult workingCopy;

    public SearchResultEditorCursor(TableViewer viewer) {
        super(viewer.getTable(), 0);
        this.viewer = viewer;
        this.selectionChangesListenerList = new ArrayList<ISelectionChangedListener>();
        this.setBackground(Display.getDefault().getSystemColor(26));
        this.setForeground(Display.getDefault().getSystemColor(27));
        EventRegistry.addEntryUpdateListener((EntryUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        this.initSelectionChecker();
        this.initSelectionProvider();
    }

    private void initSelectionChecker() {
        this.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.checkSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.checkSelection();
            }

            private void checkSelection() {
                if (SearchResultEditorCursor.this.viewer != null && SearchResultEditorCursor.this.viewer.getColumnProperties() != null && SearchResultEditorCursor.this.viewer.getColumnProperties().length - 1 < SearchResultEditorCursor.this.getColumn()) {
                    SearchResultEditorCursor.this.setSelection(SearchResultEditorCursor.this.getRow(), SearchResultEditorCursor.this.viewer.getColumnProperties().length - 1);
                }
            }
        });
    }

    private void initSelectionProvider() {
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator it = SearchResultEditorCursor.this.selectionChangesListenerList.iterator();
                while (it.hasNext()) {
                    ((ISelectionChangedListener)it.next()).selectionChanged(new SelectionChangedEvent((ISelectionProvider)SearchResultEditorCursor.this, SearchResultEditorCursor.this.getSelection()));
                }
            }
        });
    }

    public boolean setFocus() {
        return super.setFocus();
    }

    public void dispose() {
        EventRegistry.removeEntryUpdateListener((EntryUpdateListener)this);
        this.viewer = null;
        super.dispose();
    }

    public void entryUpdated(EntryModificationEvent event) {
        this.viewer.refresh();
        this.redraw();
    }

    public String getSelectedProperty() {
        if (!this.isDisposed() && this.getRow() != null && this.viewer != null && this.viewer.getColumnProperties() != null && this.viewer.getColumnProperties().length >= this.getColumn() + 1) {
            String property = (String)this.viewer.getColumnProperties()[this.getColumn()];
            return property;
        }
        return null;
    }

    public AttributeHierarchy getSelectedAttributeHierarchy() {
        if (!this.isDisposed() && this.getRow() != null && this.viewer != null && this.viewer.getColumnProperties() != null && this.viewer.getColumnProperties().length >= this.getColumn() + 1) {
            ISearchResult sr = this.getSelectedSearchResult();
            String property = (String)this.viewer.getColumnProperties()[this.getColumn()];
            if (sr != null && !"DN".equals(property)) {
                AttributeHierarchy ah = sr.getAttributeWithSubtypes(property);
                if (ah == null) {
                    ah = new AttributeHierarchy(sr.getEntry(), property, new IAttribute[]{new Attribute(sr.getEntry(), property)});
                }
                return ah;
            }
        }
        return null;
    }

    public ISearchResult getSelectedSearchResult() {
        Object o;
        if (!this.isDisposed() && this.getRow() != null && (o = this.getRow().getData()) instanceof ISearchResult) {
            ISearchResult sr = (ISearchResult)o;
            if (!sr.equals(this.workingCopy)) {
                IEntry entry = sr.getEntry();
                IEntry referenceEntry = new CompoundModification().cloneEntry(entry);
                this.referenceCopy = new SearchResult(referenceEntry, sr.getSearch());
                IEntry workingEntry = new CompoundModification().cloneEntry(entry);
                this.workingCopy = new SearchResult(workingEntry, sr.getSearch());
            }
            return this.workingCopy;
        }
        return null;
    }

    public ISearchResult getSelectedReferenceCopy() {
        return this.referenceCopy;
    }

    public void resetCopies() {
        this.referenceCopy = null;
        this.workingCopy = null;
        Iterator<ISelectionChangedListener> it = this.selectionChangesListenerList.iterator();
        while (it.hasNext()) {
            it.next().selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.selectionChangesListenerList.contains(listener)) {
            this.selectionChangesListenerList.add(listener);
        }
    }

    public ISelection getSelection() {
        ISearchResult searchResult = this.getSelectedSearchResult();
        AttributeHierarchy ah = this.getSelectedAttributeHierarchy();
        String property = this.getSelectedProperty();
        ArrayList<Object> list = new ArrayList<Object>();
        if (searchResult != null) {
            list.add(searchResult);
        }
        if (ah != null) {
            list.add(ah);
        }
        if (property != null) {
            list.add(property);
        }
        return new StructuredSelection(list);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionChangesListenerList.contains(listener)) {
            this.selectionChangesListenerList.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
    }
}

