/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.BrowserConnectionWidgetContributionItem;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.ReloadSchemaAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowser;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowserInput;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.ShowDefaultSchemaAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class SchemaPage {
    protected BrowserConnectionWidgetContributionItem connectionCombo;
    protected ShowDefaultSchemaAction showDefaultSchemaAction;
    protected ReloadSchemaAction reloadSchemaAction;
    protected SchemaBrowser schemaBrowser;
    protected FormToolkit toolkit;
    protected Form form;
    protected SashForm sashForm;
    protected ScrolledForm masterForm;
    protected ScrolledForm detailForm;
    protected SchemaDetailsPage detailsPage;
    protected Section section;
    protected Text filterText;
    protected TableViewer viewer;
    protected boolean inChange;

    public SchemaPage(SchemaBrowser schemaBrowser) {
        this.schemaBrowser = schemaBrowser;
        this.inChange = false;
    }

    public void refresh() {
        Schema schema = null;
        if (this.showDefaultSchemaAction.isChecked()) {
            schema = Schema.DEFAULT_SCHEMA;
        } else if (this.getConnection() != null) {
            schema = this.getConnection().getSchema();
        }
        if (this.viewer.getInput() != schema) {
            this.viewer.setInput((Object)schema);
            this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.form.setText(this.getTitle());
        this.viewer.refresh();
    }

    protected abstract String getTitle();

    protected abstract String getFilterDescription();

    protected abstract IStructuredContentProvider getContentProvider();

    protected abstract ITableLabelProvider getLabelProvider();

    protected abstract ViewerSorter getSorter();

    protected abstract ViewerFilter getFilter();

    protected abstract SchemaDetailsPage getDetailsPage();

    private void createMaster(Composite parent) {
        this.section = this.toolkit.createSection(parent, 128);
        this.section.marginWidth = 10;
        this.section.marginHeight = 12;
        this.section.setText(this.getTitle());
        this.section.setDescription(this.getFilterDescription());
        this.toolkit.createCompositeSeparator((Composite)this.section);
        Composite client = this.toolkit.createComposite((Composite)this.section, 64);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        client.setLayout((Layout)layout);
        this.section.setClient((Control)client);
        this.toolkit.createLabel(client, Messages.getString("SchemaPage.Filter"));
        this.filterText = this.toolkit.createText(client, "", 384);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SchemaPage.this.viewer.refresh();
            }
        });
        Table t = this.toolkit.createTable(client, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 20;
        gd.widthHint = 100;
        t.setLayoutData((Object)gd);
        this.toolkit.paintBordersFor(client);
        this.viewer = new TableViewer(t);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setSorter(this.getSorter());
        this.viewer.addFilter(this.getFilter());
    }

    private void createDetail(Composite body) {
        this.detailsPage = this.getDetailsPage();
        this.detailsPage.createContents(this.detailForm);
    }

    public void select(Object obj) {
        StructuredSelection newSelection = new StructuredSelection(obj);
        ISelection oldSelection = this.viewer.getSelection();
        if (!newSelection.equals(oldSelection)) {
            this.inChange = true;
            this.viewer.setSelection((ISelection)newSelection, true);
            if (this.viewer.getSelection().isEmpty()) {
                this.filterText.setText("");
                this.viewer.setSelection((ISelection)newSelection, true);
            }
            this.inChange = false;
        }
    }

    public void dispose() {
        this.detailsPage.dispose();
        this.schemaBrowser = null;
        this.toolkit.dispose();
        this.toolkit = null;
    }

    Control createControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        this.form.getBody().setLayout((Layout)new FillLayout());
        this.sashForm = new SashForm(this.form.getBody(), 256);
        this.sashForm.setLayout((Layout)new FillLayout());
        this.masterForm = this.toolkit.createScrolledForm((Composite)this.sashForm);
        this.detailForm = new ScrolledForm((Composite)this.sashForm, 0x200 | this.toolkit.getOrientation());
        this.detailForm.setExpandHorizontal(true);
        this.detailForm.setExpandVertical(true);
        this.detailForm.setBackground(this.toolkit.getColors().getBackground());
        this.detailForm.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.detailForm.setFont(JFaceResources.getHeaderFont());
        this.sashForm.setWeights(new int[]{50, 50});
        this.masterForm.getBody().setLayout((Layout)new FillLayout());
        this.createMaster(this.masterForm.getBody());
        this.detailForm.getBody().setLayout((Layout)new FillLayout());
        this.createDetail(this.detailForm.getBody());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    SchemaPage.this.detailsPage.setInput(null);
                } else {
                    Object obj = ((StructuredSelection)selection).getFirstElement();
                    SchemaPage.this.detailsPage.setInput(obj);
                    if (!SchemaPage.this.inChange && obj instanceof AbstractSchemaDescription) {
                        SchemaPage.this.schemaBrowser.setInput(new SchemaBrowserInput(SchemaPage.this.getConnection(), (AbstractSchemaDescription)obj));
                    }
                }
            }
        });
        this.connectionCombo = new BrowserConnectionWidgetContributionItem(this);
        this.form.getToolBarManager().add((IContributionItem)this.connectionCombo);
        this.form.getToolBarManager().add((IContributionItem)new Separator());
        this.showDefaultSchemaAction = new ShowDefaultSchemaAction(this.schemaBrowser);
        this.form.getToolBarManager().add((IAction)this.showDefaultSchemaAction);
        this.form.getToolBarManager().add((IContributionItem)new Separator());
        this.reloadSchemaAction = new ReloadSchemaAction(this);
        this.form.getToolBarManager().add((IAction)this.reloadSchemaAction);
        this.form.updateToolBar();
        this.refresh();
        return this.form;
    }

    public SchemaBrowser getSchemaBrowser() {
        return this.schemaBrowser;
    }

    public IBrowserConnection getConnection() {
        return this.connectionCombo.getConnection();
    }

    public void setConnection(IBrowserConnection connection) {
        this.connectionCombo.setConnection(connection);
        this.reloadSchemaAction.updateEnabledState();
        this.refresh();
    }

    public boolean isShowDefaultSchema() {
        return this.showDefaultSchemaAction.isChecked();
    }

    public void setShowDefaultSchema(boolean b) {
        this.showDefaultSchemaAction.setChecked(b);
        this.connectionCombo.updateEnabledState();
        this.reloadSchemaAction.updateEnabledState();
        this.refresh();
    }
}

