/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import java.util.List;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowserInput;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaDetailsPage
implements IHyperlinkListener {
    protected Section rawSection;
    protected Text rawText;
    protected FormToolkit toolkit;
    protected SchemaPage schemaPage;
    protected ScrolledForm detailForm;

    protected SchemaDetailsPage(SchemaPage schemaPage, FormToolkit toolkit) {
        this.schemaPage = schemaPage;
        this.toolkit = toolkit;
    }

    public void dispose() {
    }

    public void linkActivated(HyperlinkEvent e) {
        Object obj = e.getHref();
        if (obj instanceof AbstractSchemaDescription) {
            this.schemaPage.getSchemaBrowser().setInput(new SchemaBrowserInput(this.schemaPage.getConnection(), (AbstractSchemaDescription)obj));
        }
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    public abstract void setInput(Object var1);

    protected abstract void createContents(ScrolledForm var1);

    protected void createRawSection() {
        this.rawSection = this.toolkit.createSection(this.detailForm.getBody(), 2);
        this.rawSection.setText(Messages.getString("SchemaDetailsPage.RawSchemaDefinition"));
        this.rawSection.marginWidth = 0;
        this.rawSection.marginHeight = 0;
        this.rawSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.rawSection);
        this.rawSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                SchemaDetailsPage.this.detailForm.reflow(true);
            }
        });
    }

    protected void createRawContents(AbstractSchemaDescription asd) {
        if (this.rawSection.getClient() != null && !this.rawSection.getClient().isDisposed()) {
            this.rawSection.getClient().dispose();
        }
        Composite client = this.toolkit.createComposite((Composite)this.rawSection, 64);
        client.setLayout((Layout)new GridLayout());
        this.rawSection.setClient((Control)client);
        if (asd != null) {
            this.rawText = this.toolkit.createText(client, this.getNonNullString(SchemaUtils.getLdifLine((AbstractSchemaDescription)asd)), 66);
            GridData gd2 = new GridData(768);
            gd2.widthHint = this.detailForm.getForm().getSize().x - 100 - 60;
            this.rawText.setLayoutData((Object)gd2);
            this.rawText.setEditable(false);
        }
        this.rawSection.layout();
    }

    protected Schema getSchema() {
        return this.schemaPage.getConnection().getSchema();
    }

    protected String getNonNullString(String s) {
        return s == null ? "-" : s;
    }

    private String getNonNullString(List<String> s) {
        if (s == null || s.isEmpty()) {
            return "-";
        }
        return s.get(0);
    }
}

