/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleUseDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowser;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowserInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;

public class SchemaBrowserNavigationLocation
extends NavigationLocation {
    SchemaBrowserNavigationLocation(SchemaBrowser schemaBrowser) {
        super((IEditorPart)schemaBrowser);
    }

    public String getText() {
        AbstractSchemaDescription schemaElement = this.getSchemElement();
        if (schemaElement != null) {
            if (schemaElement instanceof ObjectClassDescription) {
                return Messages.getString("SchemaBrowserNavigationLocation.ObjectClass") + SchemaUtils.toString((AbstractSchemaDescription)schemaElement);
            }
            if (schemaElement instanceof AttributeTypeDescription) {
                return Messages.getString("SchemaBrowserNavigationLocation.AttributeType") + SchemaUtils.toString((AbstractSchemaDescription)schemaElement);
            }
            if (schemaElement instanceof LdapSyntaxDescription) {
                return Messages.getString("SchemaBrowserNavigationLocation.Syntax") + SchemaUtils.toString((AbstractSchemaDescription)schemaElement);
            }
            if (schemaElement instanceof MatchingRuleDescription) {
                return Messages.getString("SchemaBrowserNavigationLocation.MatchingRule") + SchemaUtils.toString((AbstractSchemaDescription)schemaElement);
            }
            if (schemaElement instanceof MatchingRuleUseDescription) {
                return Messages.getString("SchemaBrowserNavigationLocation.MatchingRuleUse") + SchemaUtils.toString((AbstractSchemaDescription)schemaElement);
            }
            return SchemaUtils.toString((AbstractSchemaDescription)schemaElement);
        }
        return super.getText();
    }

    public void saveState(IMemento memento) {
        IBrowserConnection connection = this.getConnection();
        AbstractSchemaDescription schemaElement = this.getSchemElement();
        memento.putString("CONNECTION", connection.getConnection().getId());
        memento.putString("SCHEMAELEMENTYPE", schemaElement.getClass().getName());
        memento.putString("SCHEMAELEMENTOID", schemaElement.getNumericOid());
    }

    public void restoreState(IMemento memento) {
        IBrowserConnection connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(memento.getString("CONNECTION"));
        String schemaElementType = memento.getString("SCHEMAELEMENTYPE");
        String schemaElementOid = memento.getString("SCHEMAELEMENTOID");
        ObjectClassDescription schemaElement = null;
        if (ObjectClassDescription.class.getName().equals(schemaElementType)) {
            schemaElement = connection.getSchema().getObjectClassDescription(schemaElementOid);
        } else if (AttributeTypeDescription.class.getName().equals(schemaElementType)) {
            schemaElement = connection.getSchema().getAttributeTypeDescription(schemaElementOid);
        } else if (LdapSyntaxDescription.class.getName().equals(schemaElementType)) {
            schemaElement = connection.getSchema().getLdapSyntaxDescription(schemaElementOid);
        } else if (MatchingRuleDescription.class.getName().equals(schemaElementType)) {
            schemaElement = connection.getSchema().getMatchingRuleDescription(schemaElementOid);
        } else if (MatchingRuleUseDescription.class.getName().equals(schemaElementType)) {
            schemaElement = connection.getSchema().getMatchingRuleUseDescription(schemaElementOid);
        }
        super.setInput((Object)new SchemaBrowserInput(connection, (AbstractSchemaDescription)schemaElement));
    }

    public void restoreLocation() {
        IEditorPart editorPart = this.getEditorPart();
        if (editorPart != null && editorPart instanceof SchemaBrowser) {
            SchemaBrowserInput sbi;
            SchemaBrowser schemaBrowser = (SchemaBrowser)editorPart;
            Object input = this.getInput();
            if (input != null && input instanceof SchemaBrowserInput && (sbi = (SchemaBrowserInput)input).getConnection() != null && sbi.getSchemaElement() != null) {
                schemaBrowser.setInput(sbi);
            }
        }
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (currentLocation == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != currentLocation.getClass()) {
            return false;
        }
        SchemaBrowserNavigationLocation location = (SchemaBrowserNavigationLocation)currentLocation;
        AbstractSchemaDescription other = location.getSchemElement();
        AbstractSchemaDescription element = this.getSchemElement();
        if (other == null && element == null) {
            return true;
        }
        if (other == null || element == null) {
            return false;
        }
        return element.equals((Object)other);
    }

    public void update() {
    }

    private AbstractSchemaDescription getSchemElement() {
        SchemaBrowserInput schemaBrowserInput;
        AbstractSchemaDescription schemaElement;
        Object editorInput = this.getInput();
        if (editorInput != null && editorInput instanceof SchemaBrowserInput && (schemaElement = (schemaBrowserInput = (SchemaBrowserInput)editorInput).getSchemaElement()) != null) {
            return schemaElement;
        }
        return null;
    }

    private IBrowserConnection getConnection() {
        Object editorInput = this.getInput();
        if (editorInput != null && editorInput instanceof SchemaBrowserInput) {
            SchemaBrowserInput schemaBrowserInput = (SchemaBrowserInput)editorInput;
            return schemaBrowserInput.getConnection();
        }
        return null;
    }

    public String toString() {
        return "" + this.getSchemElement();
    }
}

