/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReloadSchemaRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.jface.action.Action;

public class ReloadSchemaAction
extends Action {
    private SchemaPage schemaPage;

    public ReloadSchemaAction(SchemaPage schemaPage) {
        super(Messages.getString("ReloadSchemaAction.ReloadSchema"));
        super.setToolTipText(Messages.getString("ReloadSchemaAction.ReloadSchemaToolTip"));
        super.setImageDescriptor(BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/refresh.gif"));
        super.setEnabled(true);
        this.schemaPage = schemaPage;
    }

    public void run() {
        IBrowserConnection browserConnection = this.schemaPage.getConnection();
        if (browserConnection != null) {
            new StudioBrowserJob(new StudioRunnableWithProgress[]{new ReloadSchemaRunnable(browserConnection)}).execute();
            this.schemaPage.getSchemaBrowser().refresh();
        }
    }

    public void dispose() {
        this.schemaPage = null;
    }

    public void updateEnabledState() {
        this.setEnabled(this.schemaPage.getConnection() != null && !this.schemaPage.isShowDefaultSchema());
    }
}

