/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.ObjectClassDescriptionDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowser;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class ObjectClassDescriptionPage
extends SchemaPage {
    public ObjectClassDescriptionPage(SchemaBrowser schemaBrowser) {
        super(schemaBrowser);
    }

    protected String getTitle() {
        return Messages.getString("ObjectClassDescriptionPage.ObjectClasses");
    }

    protected String getFilterDescription() {
        return Messages.getString("ObjectClassDescriptionPage.SelectObjectClass");
    }

    protected IStructuredContentProvider getContentProvider() {
        return new OCDContentProvider();
    }

    protected ITableLabelProvider getLabelProvider() {
        return new OCDLabelProvider();
    }

    protected ViewerSorter getSorter() {
        return new OCDViewerSorter();
    }

    protected ViewerFilter getFilter() {
        return new OCDViewerFilter();
    }

    protected SchemaDetailsPage getDetailsPage() {
        return new ObjectClassDescriptionDetailsPage(this, this.toolkit);
    }

    class OCDViewerFilter
    extends ViewerFilter {
        OCDViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ObjectClassDescription) {
                ObjectClassDescription ocd = (ObjectClassDescription)element;
                boolean matched = SchemaUtils.toString((AbstractSchemaDescription)ocd).toLowerCase().indexOf(ObjectClassDescriptionPage.this.filterText.getText().toLowerCase()) != -1 || ocd.getNumericOid().toLowerCase().indexOf(ObjectClassDescriptionPage.this.filterText.getText().toLowerCase()) != -1;
                return matched;
            }
            return false;
        }
    }

    class OCDViewerSorter
    extends ViewerSorter {
        OCDViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ObjectClassDescription) {
                e1 = SchemaUtils.toString((AbstractSchemaDescription)((ObjectClassDescription)e1));
            }
            if (e2 instanceof ObjectClassDescription) {
                e2 = SchemaUtils.toString((AbstractSchemaDescription)((ObjectClassDescription)e2));
            }
            return e1.toString().compareTo(e2.toString());
        }
    }

    class OCDLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        OCDLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ObjectClassDescription) {
                return SchemaUtils.toString((AbstractSchemaDescription)((ObjectClassDescription)obj));
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class OCDContentProvider
    implements IStructuredContentProvider {
        OCDContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Schema schema;
            if (inputElement instanceof Schema && (schema = (Schema)inputElement) != null) {
                return schema.getObjectClassDescriptions().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

