/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import java.util.Collection;
import java.util.List;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ObjectClassDescriptionDetailsPage
extends SchemaDetailsPage {
    private Section mainSection;
    private Text numericOidText;
    private Text namesText;
    private Text descText;
    private Text kindText;
    private Section superclassesSection;
    private Section subclassesSection;
    private Section mustSection;
    private Section maySection;

    public ObjectClassDescriptionDetailsPage(SchemaPage schemaPage, FormToolkit toolkit) {
        super(schemaPage, toolkit);
    }

    public void createContents(final ScrolledForm detailForm) {
        this.detailForm = detailForm;
        detailForm.getBody().setLayout((Layout)new GridLayout());
        this.mainSection = this.toolkit.createSection(detailForm.getBody(), 0);
        this.mainSection.setText(Messages.getString("ObjectClassDescriptionDetailsPage.Details"));
        this.mainSection.marginWidth = 0;
        this.mainSection.marginHeight = 0;
        this.mainSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.mainSection);
        this.mustSection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.mustSection.setText(Messages.getString("ObjectClassDescriptionDetailsPage.MustAttributes"));
        this.mustSection.marginWidth = 0;
        this.mustSection.marginHeight = 0;
        this.mustSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.mustSection);
        this.mustSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        this.maySection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.maySection.setText(Messages.getString("ObjectClassDescriptionDetailsPage.MayAttributes"));
        this.maySection.marginWidth = 0;
        this.maySection.marginHeight = 0;
        this.maySection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.maySection);
        this.maySection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        this.superclassesSection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.superclassesSection.setText(Messages.getString("ObjectClassDescriptionDetailsPage.Superclasses"));
        this.superclassesSection.marginWidth = 0;
        this.superclassesSection.marginHeight = 0;
        this.superclassesSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.superclassesSection);
        this.superclassesSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        this.subclassesSection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.subclassesSection.setText(Messages.getString("ObjectClassDescriptionDetailsPage.Subclasses"));
        this.subclassesSection.marginWidth = 0;
        this.subclassesSection.marginHeight = 0;
        this.subclassesSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.subclassesSection);
        this.subclassesSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        this.createRawSection();
    }

    public void setInput(Object input) {
        ObjectClassDescription ocd = null;
        if (input instanceof ObjectClassDescription) {
            ocd = (ObjectClassDescription)input;
        }
        this.createMainContent(ocd);
        this.createSuperclassContents(ocd);
        this.createSubclassContents(ocd);
        this.createMustContents(ocd);
        this.createMayContents(ocd);
        super.createRawContents((AbstractSchemaDescription)ocd);
        this.detailForm.reflow(true);
    }

    private void createMainContent(ObjectClassDescription ocd) {
        if (this.mainSection.getClient() != null) {
            this.mainSection.getClient().dispose();
        }
        Composite mainClient = this.toolkit.createComposite((Composite)this.mainSection, 64);
        GridLayout mainLayout = new GridLayout(2, false);
        mainClient.setLayout((Layout)mainLayout);
        this.mainSection.setClient((Control)mainClient);
        if (ocd != null) {
            this.toolkit.createLabel(mainClient, Messages.getString("ObjectClassDescriptionDetailsPage.NumericOID"), 0);
            this.numericOidText = this.toolkit.createText(mainClient, this.getNonNullString(ocd.getNumericOid()), 0);
            this.numericOidText.setLayoutData((Object)new GridData(768));
            this.numericOidText.setEditable(false);
            this.toolkit.createLabel(mainClient, Messages.getString("ObjectClassDescriptionDetailsPage.ObjectclassNames"), 0);
            this.namesText = this.toolkit.createText(mainClient, this.getNonNullString(SchemaUtils.toString((AbstractSchemaDescription)ocd)), 0);
            this.namesText.setLayoutData((Object)new GridData(768));
            this.namesText.setEditable(false);
            this.toolkit.createLabel(mainClient, Messages.getString("ObjectClassDescriptionDetailsPage.Description"), 0);
            this.descText = this.toolkit.createText(mainClient, this.getNonNullString(ocd.getDescription()), 66);
            GridData gd = new GridData(768);
            gd.widthHint = this.detailForm.getForm().getSize().x - 100 - 60;
            this.descText.setLayoutData((Object)gd);
            this.descText.setEditable(false);
            String kind = "";
            switch (ocd.getKind()) {
                case STRUCTURAL: {
                    kind = Messages.getString("ObjectClassDescriptionDetailsPage.Structural");
                    break;
                }
                case ABSTRACT: {
                    kind = Messages.getString("ObjectClassDescriptionDetailsPage.Abstract");
                    break;
                }
                case AUXILIARY: {
                    kind = Messages.getString("ObjectClassDescriptionDetailsPage.Auxiliary");
                }
            }
            if (ocd.isObsolete()) {
                kind = kind + Messages.getString("ObjectClassDescriptionDetailsPage.Obsolete");
            }
            this.toolkit.createLabel(mainClient, Messages.getString("ObjectClassDescriptionDetailsPage.ObjectclassKind"), 0);
            this.kindText = this.toolkit.createText(mainClient, this.getNonNullString(kind), 0);
            this.kindText.setLayoutData((Object)new GridData(768));
            this.kindText.setEditable(false);
        }
        this.mainSection.layout();
    }

    private void createMustContents(ObjectClassDescription ocd) {
        if (this.mustSection.getClient() != null) {
            this.mustSection.getClient().dispose();
        }
        Composite mustClient = this.toolkit.createComposite((Composite)this.mustSection, 64);
        mustClient.setLayout((Layout)new GridLayout());
        this.mustSection.setClient((Control)mustClient);
        if (ocd != null) {
            Collection names = SchemaUtils.getMustAttributeTypeDescriptionNamesTransitive((ObjectClassDescription)ocd, (Schema)this.getSchema());
            if (names != null && names.size() > 0) {
                this.mustSection.setText(NLS.bind((String)Messages.getString("ObjectClassDescriptionDetailsPage.MustAttributesCount"), (Object[])new Object[]{names.size()}));
                for (String name : names) {
                    if (this.getSchema().hasAttributeTypeDescription(name)) {
                        AttributeTypeDescription mustAtd = this.getSchema().getAttributeTypeDescription(name);
                        Hyperlink mustLink = this.toolkit.createHyperlink(mustClient, SchemaUtils.toString((AbstractSchemaDescription)mustAtd), 64);
                        mustLink.setHref((Object)mustAtd);
                        mustLink.setLayoutData((Object)new GridData(768));
                        mustLink.setUnderlined(true);
                        mustLink.setEnabled(true);
                        mustLink.addHyperlinkListener((IHyperlinkListener)this);
                        continue;
                    }
                    Hyperlink mustLink = this.toolkit.createHyperlink(mustClient, name, 64);
                    mustLink.setHref(null);
                    mustLink.setUnderlined(false);
                    mustLink.setEnabled(false);
                }
            } else {
                this.mustSection.setText(NLS.bind((String)Messages.getString("ObjectClassDescriptionDetailsPage.MustAttributesCount"), (Object[])new Object[]{0}));
                Text mustText = this.toolkit.createText(mustClient, this.getNonNullString(null), 0);
                mustText.setLayoutData((Object)new GridData(768));
                mustText.setEditable(false);
            }
        } else {
            this.mustSection.setText(Messages.getString("ObjectClassDescriptionDetailsPage.MustAttributes"));
        }
        this.mustSection.layout();
    }

    private void createMayContents(ObjectClassDescription ocd) {
        if (this.maySection.getClient() != null) {
            this.maySection.getClient().dispose();
        }
        Composite mayClient = this.toolkit.createComposite((Composite)this.maySection, 64);
        mayClient.setLayout((Layout)new GridLayout());
        this.maySection.setClient((Control)mayClient);
        if (ocd != null) {
            Collection names = SchemaUtils.getMayAttributeTypeDescriptionNamesTransitive((ObjectClassDescription)ocd, (Schema)this.getSchema());
            if (names != null && names.size() > 0) {
                this.maySection.setText(NLS.bind((String)Messages.getString("ObjectClassDescriptionDetailsPage.MayAttributesCount"), (Object[])new Object[]{names.size()}));
                for (String name : names) {
                    if (this.getSchema().hasAttributeTypeDescription(name)) {
                        AttributeTypeDescription mayAtd = this.getSchema().getAttributeTypeDescription(name);
                        Hyperlink mayLink = this.toolkit.createHyperlink(mayClient, SchemaUtils.toString((AbstractSchemaDescription)mayAtd), 64);
                        mayLink.setHref((Object)mayAtd);
                        mayLink.setLayoutData((Object)new GridData(768));
                        mayLink.setUnderlined(true);
                        mayLink.setEnabled(true);
                        mayLink.addHyperlinkListener((IHyperlinkListener)this);
                        continue;
                    }
                    Hyperlink mayLink = this.toolkit.createHyperlink(mayClient, name, 64);
                    mayLink.setHref(null);
                    mayLink.setUnderlined(false);
                    mayLink.setEnabled(false);
                }
            } else {
                this.maySection.setText(NLS.bind((String)Messages.getString("ObjectClassDescriptionDetailsPage.MayAttributesCount"), (Object[])new Object[]{0}));
                Text mayText = this.toolkit.createText(mayClient, this.getNonNullString(null), 0);
                mayText.setLayoutData((Object)new GridData(768));
                mayText.setEditable(false);
            }
        } else {
            this.maySection.setText(Messages.getString("ObjectClassDescriptionDetailsPage.MayAttributes"));
        }
        this.maySection.layout();
    }

    private void createSubclassContents(ObjectClassDescription ocd) {
        if (this.subclassesSection.getClient() != null) {
            this.subclassesSection.getClient().dispose();
        }
        Composite subClient = this.toolkit.createComposite((Composite)this.subclassesSection, 64);
        subClient.setLayout((Layout)new GridLayout());
        this.subclassesSection.setClient((Control)subClient);
        if (ocd != null) {
            List subOcds = SchemaUtils.getSubObjectClassDescriptions((ObjectClassDescription)ocd, (Schema)this.getSchema());
            if (subOcds != null && subOcds.size() > 0) {
                this.subclassesSection.setText(NLS.bind((String)Messages.getString("ObjectClassDescriptionDetailsPage.SubclassesCount"), (Object[])new Object[]{subOcds.size()}));
                for (ObjectClassDescription subOcd : subOcds) {
                    Hyperlink subLink = this.toolkit.createHyperlink(subClient, SchemaUtils.toString((AbstractSchemaDescription)subOcd), 64);
                    subLink.setHref((Object)subOcd);
                    subLink.setLayoutData((Object)new GridData(768));
                    subLink.setUnderlined(true);
                    subLink.setEnabled(true);
                    subLink.addHyperlinkListener((IHyperlinkListener)this);
                }
            } else {
                this.subclassesSection.setText(NLS.bind((String)Messages.getString("ObjectClassDescriptionDetailsPage.SubclassesCount"), (Object[])new Object[]{0}));
                Text derivedText = this.toolkit.createText(subClient, this.getNonNullString(null), 0);
                derivedText.setLayoutData((Object)new GridData(768));
                derivedText.setEditable(false);
            }
        } else {
            this.subclassesSection.setText(Messages.getString("ObjectClassDescriptionDetailsPage.Subclasses"));
        }
        this.subclassesSection.layout();
    }

    private void createSuperclassContents(ObjectClassDescription ocd) {
        if (this.superclassesSection.getClient() != null) {
            this.superclassesSection.getClient().dispose();
        }
        Composite superClient = this.toolkit.createComposite((Composite)this.superclassesSection, 64);
        superClient.setLayout((Layout)new GridLayout());
        this.superclassesSection.setClient((Control)superClient);
        if (ocd != null) {
            List names = ocd.getSuperiorObjectClasses();
            if (names != null && names.size() > 0) {
                this.superclassesSection.setText(NLS.bind((String)Messages.getString("ObjectClassDescriptionDetailsPage.SuperclassesCount"), (Object[])new Object[]{names.size()}));
                Composite supClient = this.toolkit.createComposite(superClient, 64);
                GridLayout gl = new GridLayout();
                gl.marginWidth = 0;
                gl.marginHeight = 0;
                supClient.setLayout((Layout)gl);
                for (String name : names) {
                    if (this.getSchema().hasObjectClassDescription(name)) {
                        ObjectClassDescription supOcd = this.getSchema().getObjectClassDescription(name);
                        Hyperlink superLink = this.toolkit.createHyperlink(supClient, SchemaUtils.toString((AbstractSchemaDescription)supOcd), 64);
                        superLink.setHref((Object)supOcd);
                        superLink.setLayoutData((Object)new GridData(768));
                        superLink.setUnderlined(true);
                        superLink.setEnabled(true);
                        superLink.addHyperlinkListener((IHyperlinkListener)this);
                        continue;
                    }
                    Hyperlink superLink = this.toolkit.createHyperlink(supClient, name, 64);
                    superLink.setHref(null);
                    superLink.setUnderlined(false);
                    superLink.setEnabled(false);
                }
            } else {
                this.superclassesSection.setText(NLS.bind((String)Messages.getString("ObjectClassDescriptionDetailsPage.SuperclassesCount"), (Object[])new Object[]{0}));
                Text superText = this.toolkit.createText(superClient, this.getNonNullString(null), 0);
                superText.setLayoutData((Object)new GridData(768));
                superText.setEditable(false);
            }
        } else {
            this.superclassesSection.setText(Messages.getString("ObjectClassDescriptionDetailsPage.Superclasses"));
        }
        this.superclassesSection.layout();
    }
}

