/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescription;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.MatchingRuleDescriptionDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowser;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class MatchingRuleDescriptionPage
extends SchemaPage {
    public MatchingRuleDescriptionPage(SchemaBrowser schemaBrowser) {
        super(schemaBrowser);
    }

    protected String getTitle() {
        return Messages.getString("MatchingRuleDescriptionPage.MatchingRules");
    }

    protected String getFilterDescription() {
        return Messages.getString("MatchingRuleDescriptionPage.SelectMatchingRule");
    }

    protected IStructuredContentProvider getContentProvider() {
        return new MRDContentProvider();
    }

    protected ITableLabelProvider getLabelProvider() {
        return new MRDLabelProvider();
    }

    protected ViewerSorter getSorter() {
        return new MRDViewerSorter();
    }

    protected ViewerFilter getFilter() {
        return new MRDViewerFilter();
    }

    protected SchemaDetailsPage getDetailsPage() {
        return new MatchingRuleDescriptionDetailsPage(this, this.toolkit);
    }

    class MRDViewerFilter
    extends ViewerFilter {
        MRDViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof MatchingRuleDescription) {
                MatchingRuleDescription mrd = (MatchingRuleDescription)element;
                boolean matched = SchemaUtils.toString((AbstractSchemaDescription)mrd).toLowerCase().indexOf(MatchingRuleDescriptionPage.this.filterText.getText().toLowerCase()) != -1 || mrd.getNumericOid().toLowerCase().indexOf(MatchingRuleDescriptionPage.this.filterText.getText().toLowerCase()) != -1;
                return matched;
            }
            return false;
        }
    }

    class MRDViewerSorter
    extends ViewerSorter {
        MRDViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof MatchingRuleDescription) {
                e1 = SchemaUtils.toString((AbstractSchemaDescription)((MatchingRuleDescription)e1));
            }
            if (e2 instanceof MatchingRuleDescription) {
                e2 = SchemaUtils.toString((AbstractSchemaDescription)((MatchingRuleDescription)e2));
            }
            return e1.toString().compareTo(e2.toString());
        }
    }

    class MRDLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        MRDLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof MatchingRuleDescription) {
                return SchemaUtils.toString((AbstractSchemaDescription)((MatchingRuleDescription)obj));
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class MRDContentProvider
    implements IStructuredContentProvider {
        MRDContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Schema schema;
            if (inputElement instanceof Schema && (schema = (Schema)inputElement) != null && schema.getMatchingRuleDescriptions() != null) {
                return schema.getMatchingRuleDescriptions().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

