/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import java.util.Collection;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescription;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class MatchingRuleDescriptionDetailsPage
extends SchemaDetailsPage {
    private Section mainSection;
    private Text numericOidText;
    private Text namesText;
    private Text descText;
    private Section flagSection;
    private Label isObsoleteText;
    private Section syntaxSection;
    private Text syntaxDescText;
    private Hyperlink syntaxLink;
    private Section usedFromSection;

    public MatchingRuleDescriptionDetailsPage(SchemaPage scheamPage, FormToolkit toolkit) {
        super(scheamPage, toolkit);
    }

    public void createContents(final ScrolledForm detailForm) {
        this.detailForm = detailForm;
        detailForm.getBody().setLayout((Layout)new GridLayout());
        this.mainSection = this.toolkit.createSection(detailForm.getBody(), 0);
        this.mainSection.setText(Messages.getString("MatchingRuleDescriptionDetailsPage.Details"));
        this.mainSection.marginWidth = 0;
        this.mainSection.marginHeight = 0;
        this.mainSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.mainSection);
        this.flagSection = this.toolkit.createSection(detailForm.getBody(), 0);
        this.flagSection.setText(Messages.getString("MatchingRuleDescriptionDetailsPage.Flags"));
        this.flagSection.marginWidth = 0;
        this.flagSection.marginHeight = 0;
        this.flagSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.flagSection);
        Composite flagClient = this.toolkit.createComposite((Composite)this.flagSection, 64);
        GridLayout flagLayout = new GridLayout();
        flagLayout.numColumns = 1;
        flagLayout.marginWidth = 0;
        flagLayout.marginHeight = 0;
        flagClient.setLayout((Layout)flagLayout);
        this.flagSection.setClient((Control)flagClient);
        this.isObsoleteText = this.toolkit.createLabel(flagClient, Messages.getString("MatchingRuleDescriptionDetailsPage.Obsolete"), 32);
        this.isObsoleteText.setLayoutData((Object)new GridData(768));
        this.isObsoleteText.setEnabled(false);
        this.syntaxSection = this.toolkit.createSection(detailForm.getBody(), 0);
        this.syntaxSection.setText(Messages.getString("MatchingRuleDescriptionDetailsPage.Syntax"));
        this.syntaxSection.marginWidth = 0;
        this.syntaxSection.marginHeight = 0;
        this.syntaxSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.syntaxSection);
        Composite syntaxClient = this.toolkit.createComposite((Composite)this.syntaxSection, 64);
        GridLayout syntaxLayout = new GridLayout();
        syntaxLayout.numColumns = 2;
        syntaxLayout.marginWidth = 0;
        syntaxLayout.marginHeight = 0;
        syntaxClient.setLayout((Layout)syntaxLayout);
        this.syntaxSection.setClient((Control)syntaxClient);
        this.toolkit.createLabel(syntaxClient, Messages.getString("MatchingRuleDescriptionDetailsPage.SyntaxOID"), 0);
        this.syntaxLink = this.toolkit.createHyperlink(syntaxClient, "", 64);
        this.syntaxLink.setLayoutData((Object)new GridData(768));
        this.syntaxLink.addHyperlinkListener((IHyperlinkListener)this);
        this.toolkit.createLabel(syntaxClient, Messages.getString("MatchingRuleDescriptionDetailsPage.SyntaxDescription"), 0);
        this.syntaxDescText = this.toolkit.createText(syntaxClient, "", 0);
        this.syntaxDescText.setLayoutData((Object)new GridData(768));
        this.syntaxDescText.setEditable(false);
        this.usedFromSection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.usedFromSection.setText(Messages.getString("MatchingRuleDescriptionDetailsPage.UsedFrom"));
        this.usedFromSection.marginWidth = 0;
        this.usedFromSection.marginHeight = 0;
        this.usedFromSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.usedFromSection);
        this.usedFromSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        this.createRawSection();
    }

    public void setInput(Object input) {
        MatchingRuleDescription mrd = null;
        if (input instanceof MatchingRuleDescription) {
            mrd = (MatchingRuleDescription)input;
        }
        this.createMainContent(mrd);
        this.isObsoleteText.setEnabled(mrd != null && mrd.isObsolete());
        String lsdOid = null;
        LdapSyntaxDescription lsd = null;
        if (mrd != null) {
            Schema schema = this.getSchema();
            lsdOid = mrd.getSyntax();
            if (lsdOid != null && schema.hasLdapSyntaxDescription(lsdOid)) {
                lsd = schema.getLdapSyntaxDescription(lsdOid);
            }
        }
        this.syntaxLink.setText(this.getNonNullString(lsd != null ? lsd.getNumericOid() : lsdOid));
        this.syntaxLink.setHref(lsd);
        this.syntaxLink.setUnderlined(lsd != null);
        this.syntaxLink.setEnabled(lsd != null);
        this.syntaxDescText.setText(this.getNonNullString(lsd != null ? lsd.getDescription() : null));
        this.syntaxSection.layout();
        this.createUsedFromContents(mrd);
        this.createRawContents((AbstractSchemaDescription)mrd);
        this.detailForm.reflow(true);
    }

    private void createMainContent(MatchingRuleDescription mrd) {
        if (this.mainSection.getClient() != null) {
            this.mainSection.getClient().dispose();
        }
        Composite mainClient = this.toolkit.createComposite((Composite)this.mainSection, 64);
        GridLayout mainLayout = new GridLayout(2, false);
        mainClient.setLayout((Layout)mainLayout);
        this.mainSection.setClient((Control)mainClient);
        if (mrd != null) {
            this.toolkit.createLabel(mainClient, Messages.getString("MatchingRuleDescriptionDetailsPage.NumericOID"), 0);
            this.numericOidText = this.toolkit.createText(mainClient, this.getNonNullString(mrd.getNumericOid()), 0);
            this.numericOidText.setLayoutData((Object)new GridData(768));
            this.numericOidText.setEditable(false);
            this.toolkit.createLabel(mainClient, Messages.getString("MatchingRuleDescriptionDetailsPage.MatchingRule"), 0);
            this.namesText = this.toolkit.createText(mainClient, this.getNonNullString(SchemaUtils.toString((AbstractSchemaDescription)mrd)), 0);
            this.namesText.setLayoutData((Object)new GridData(768));
            this.namesText.setEditable(false);
            this.toolkit.createLabel(mainClient, Messages.getString("MatchingRuleDescriptionDetailsPage.Description"), 0);
            this.descText = this.toolkit.createText(mainClient, this.getNonNullString(mrd.getDescription()), 66);
            GridData gd = new GridData(768);
            gd.widthHint = this.detailForm.getForm().getSize().x - 100 - 60;
            this.descText.setLayoutData((Object)gd);
            this.descText.setEditable(false);
        }
        this.mainSection.layout();
    }

    private void createUsedFromContents(MatchingRuleDescription mrd) {
        if (this.usedFromSection.getClient() != null) {
            this.usedFromSection.getClient().dispose();
        }
        Composite usedFromClient = this.toolkit.createComposite((Composite)this.usedFromSection, 64);
        usedFromClient.setLayout((Layout)new GridLayout());
        this.usedFromSection.setClient((Control)usedFromClient);
        if (mrd != null) {
            Collection usedFromATDs = SchemaUtils.getUsedFromAttributeTypeDescriptions((MatchingRuleDescription)mrd, (Schema)this.getSchema());
            if (usedFromATDs != null && usedFromATDs.size() > 0) {
                this.usedFromSection.setText(NLS.bind((String)Messages.getString("MatchingRuleDescriptionDetailsPage.UsedFromCount"), (Object[])new Object[]{usedFromATDs.size()}));
                for (AttributeTypeDescription atd : usedFromATDs) {
                    Hyperlink usedFromLink = this.toolkit.createHyperlink(usedFromClient, SchemaUtils.toString((AbstractSchemaDescription)atd), 64);
                    usedFromLink.setHref((Object)atd);
                    usedFromLink.setLayoutData((Object)new GridData(768));
                    usedFromLink.setUnderlined(true);
                    usedFromLink.setEnabled(true);
                    usedFromLink.addHyperlinkListener((IHyperlinkListener)this);
                }
            } else {
                this.usedFromSection.setText(NLS.bind((String)Messages.getString("MatchingRuleDescriptionDetailsPage.UsedFromCount"), (Object[])new Object[]{0}));
                Text usedFromText = this.toolkit.createText(usedFromClient, this.getNonNullString(null), 0);
                usedFromText.setLayoutData((Object)new GridData(768));
                usedFromText.setEditable(false);
            }
        } else {
            this.usedFromSection.setText(Messages.getString("MatchingRuleDescriptionDetailsPage.UsedFrom"));
        }
        this.usedFromSection.layout();
    }
}

