/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescription;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.LdapSyntaxDescriptionDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowser;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class LdapSyntaxDescriptionPage
extends SchemaPage {
    public LdapSyntaxDescriptionPage(SchemaBrowser schemaBrowser) {
        super(schemaBrowser);
    }

    protected String getTitle() {
        return Messages.getString("LdapSyntaxDescriptionPage.Syntaxes");
    }

    protected String getFilterDescription() {
        return Messages.getString("LdapSyntaxDescriptionPage.SelectASyntax");
    }

    protected IStructuredContentProvider getContentProvider() {
        return new LSDContentProvider();
    }

    protected ITableLabelProvider getLabelProvider() {
        return new LSDLabelProvider();
    }

    protected ViewerSorter getSorter() {
        return new LSDViewerSorter();
    }

    protected ViewerFilter getFilter() {
        return new LSDViewerFilter();
    }

    protected SchemaDetailsPage getDetailsPage() {
        return new LdapSyntaxDescriptionDetailsPage(this, this.toolkit);
    }

    class LSDViewerFilter
    extends ViewerFilter {
        LSDViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof LdapSyntaxDescription) {
                LdapSyntaxDescription lsd = (LdapSyntaxDescription)element;
                boolean matched = SchemaUtils.toString((AbstractSchemaDescription)lsd).toLowerCase().indexOf(LdapSyntaxDescriptionPage.this.filterText.getText().toLowerCase()) != -1 || lsd.getNumericOid().toLowerCase().indexOf(LdapSyntaxDescriptionPage.this.filterText.getText().toLowerCase()) != -1;
                return matched;
            }
            return false;
        }
    }

    class LSDViewerSorter
    extends ViewerSorter {
        LSDViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof LdapSyntaxDescription) {
                e1 = SchemaUtils.toString((AbstractSchemaDescription)((LdapSyntaxDescription)e1));
            }
            if (e2 instanceof LdapSyntaxDescription) {
                e2 = SchemaUtils.toString((AbstractSchemaDescription)((LdapSyntaxDescription)e2));
            }
            return e1.toString().compareTo(e2.toString());
        }
    }

    class LSDLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        LSDLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof LdapSyntaxDescription) {
                return SchemaUtils.toString((AbstractSchemaDescription)((LdapSyntaxDescription)obj));
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class LSDContentProvider
    implements IStructuredContentProvider {
        LSDContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Schema schema;
            if (inputElement instanceof Schema && (schema = (Schema)inputElement) != null && schema.getLdapSyntaxDescriptions() != null) {
                return schema.getLdapSyntaxDescriptions().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

