/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import java.util.Collection;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescription;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class LdapSyntaxDescriptionDetailsPage
extends SchemaDetailsPage {
    private Section mainSection;
    private Section usedFromSection;

    public LdapSyntaxDescriptionDetailsPage(SchemaPage schemaPage, FormToolkit toolkit) {
        super(schemaPage, toolkit);
    }

    public void createContents(final ScrolledForm detailForm) {
        this.detailForm = detailForm;
        detailForm.getBody().setLayout((Layout)new GridLayout());
        this.mainSection = this.toolkit.createSection(detailForm.getBody(), 0);
        this.mainSection.setText(Messages.getString("LdapSyntaxDescriptionDetailsPage.Details"));
        this.mainSection.marginWidth = 0;
        this.mainSection.marginHeight = 0;
        this.mainSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.mainSection);
        this.usedFromSection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.usedFromSection.setText(Messages.getString("LdapSyntaxDescriptionDetailsPage.UsedFrom"));
        this.usedFromSection.marginWidth = 0;
        this.usedFromSection.marginHeight = 0;
        this.usedFromSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.usedFromSection);
        this.usedFromSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        this.createRawSection();
    }

    public void setInput(Object input) {
        LdapSyntaxDescription lsd = null;
        if (input instanceof LdapSyntaxDescription) {
            lsd = (LdapSyntaxDescription)input;
        }
        this.createMainContent(lsd);
        this.createUsedFromContents(lsd);
        this.createRawContents((AbstractSchemaDescription)lsd);
        this.detailForm.reflow(true);
    }

    private void createMainContent(LdapSyntaxDescription lsd) {
        if (this.mainSection.getClient() != null) {
            this.mainSection.getClient().dispose();
        }
        Composite mainClient = this.toolkit.createComposite((Composite)this.mainSection, 64);
        GridLayout mainLayout = new GridLayout(2, false);
        mainClient.setLayout((Layout)mainLayout);
        this.mainSection.setClient((Control)mainClient);
        if (lsd != null) {
            this.toolkit.createLabel(mainClient, Messages.getString("LdapSyntaxDescriptionDetailsPage.NumericOID"), 0);
            Text numericOidText = this.toolkit.createText(mainClient, this.getNonNullString(lsd.getNumericOid()), 0);
            numericOidText.setLayoutData((Object)new GridData(768));
            numericOidText.setEditable(false);
            this.toolkit.createLabel(mainClient, Messages.getString("LdapSyntaxDescriptionDetailsPage.Description"), 0);
            Text descText = this.toolkit.createText(mainClient, this.getNonNullString(lsd.getDescription()), 66);
            GridData gd = new GridData(768);
            gd.widthHint = this.detailForm.getForm().getSize().x - 100 - 60;
            descText.setLayoutData((Object)gd);
            descText.setEditable(false);
        }
        this.mainSection.layout();
    }

    private void createUsedFromContents(LdapSyntaxDescription lsd) {
        if (this.usedFromSection.getClient() != null && !this.usedFromSection.getClient().isDisposed()) {
            this.usedFromSection.getClient().dispose();
        }
        Composite usedFromClient = this.toolkit.createComposite((Composite)this.usedFromSection, 64);
        usedFromClient.setLayout((Layout)new GridLayout());
        this.usedFromSection.setClient((Control)usedFromClient);
        if (lsd != null) {
            Collection usedFromATDs = SchemaUtils.getUsedFromAttributeTypeDescriptions((LdapSyntaxDescription)lsd, (Schema)this.getSchema());
            if (usedFromATDs != null && !usedFromATDs.isEmpty()) {
                this.usedFromSection.setText(NLS.bind((String)Messages.getString("LdapSyntaxDescriptionDetailsPage.UsedFromCount"), (Object[])new Object[]{usedFromATDs.size()}));
                for (AttributeTypeDescription atd : usedFromATDs) {
                    Hyperlink usedFromLink = this.toolkit.createHyperlink(usedFromClient, SchemaUtils.toString((AbstractSchemaDescription)atd), 64);
                    usedFromLink.setHref((Object)atd);
                    usedFromLink.setLayoutData((Object)new GridData(768));
                    usedFromLink.setUnderlined(true);
                    usedFromLink.setEnabled(true);
                    usedFromLink.addHyperlinkListener((IHyperlinkListener)this);
                }
            } else {
                this.usedFromSection.setText(NLS.bind((String)Messages.getString("LdapSyntaxDescriptionDetailsPage.UsedFromCount"), (Object[])new Object[]{0}));
                Text usedFromText = this.toolkit.createText(usedFromClient, this.getNonNullString(null), 0);
                usedFromText.setLayoutData((Object)new GridData(768));
                usedFromText.setEditable(false);
            }
        } else {
            this.usedFromSection.setText(Messages.getString("LdapSyntaxDescriptionDetailsPage.UsedFrom"));
        }
        this.usedFromSection.layout();
    }
}

