/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.AttributeTypeDescriptionDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowser;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class AttributeTypeDescriptionPage
extends SchemaPage {
    public AttributeTypeDescriptionPage(SchemaBrowser schemaBrowser) {
        super(schemaBrowser);
    }

    protected String getTitle() {
        return Messages.getString("AttributeTypeDescriptionPage.AttributeTypes");
    }

    protected String getFilterDescription() {
        return Messages.getString("AttributeTypeDescriptionPage.SelectAttributeType");
    }

    protected IStructuredContentProvider getContentProvider() {
        return new ATDContentProvider();
    }

    protected ITableLabelProvider getLabelProvider() {
        return new ATDLabelProvider();
    }

    protected ViewerSorter getSorter() {
        return new ATDViewerSorter();
    }

    protected ViewerFilter getFilter() {
        return new ATDViewerFilter();
    }

    protected SchemaDetailsPage getDetailsPage() {
        return new AttributeTypeDescriptionDetailsPage(this, this.toolkit);
    }

    class ATDViewerFilter
    extends ViewerFilter {
        ATDViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof AttributeTypeDescription) {
                AttributeTypeDescription atd = (AttributeTypeDescription)element;
                boolean matched = SchemaUtils.toString((AbstractSchemaDescription)atd).toLowerCase().indexOf(AttributeTypeDescriptionPage.this.filterText.getText().toLowerCase()) != -1 || atd.getNumericOid().toLowerCase().indexOf(AttributeTypeDescriptionPage.this.filterText.getText().toLowerCase()) != -1;
                return matched;
            }
            return false;
        }
    }

    class ATDViewerSorter
    extends ViewerSorter {
        ATDViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof AttributeTypeDescription) {
                e1 = SchemaUtils.toString((AbstractSchemaDescription)((AbstractSchemaDescription)e1));
            }
            if (e2 instanceof AttributeTypeDescription) {
                e2 = SchemaUtils.toString((AbstractSchemaDescription)((AbstractSchemaDescription)e2));
            }
            return e1.toString().compareTo(e2.toString());
        }
    }

    class ATDLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ATDLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof AttributeTypeDescription) {
                return SchemaUtils.toString((AbstractSchemaDescription)((AbstractSchemaDescription)obj));
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class ATDContentProvider
    implements IStructuredContentProvider {
        ATDContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Schema schema;
            if (inputElement instanceof Schema && (schema = (Schema)inputElement) != null) {
                return schema.getAttributeTypeDescriptions().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

