/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.entry;

import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.entryeditors.EntryEditorUtils;
import org.apache.directory.studio.entryeditors.IEntryEditor;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.LdifEntryEditorDocumentProvider;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.LdifEntryEditorNavigationLocation;
import org.apache.directory.studio.ldifeditor.editor.LdifEditor;
import org.apache.directory.studio.ldifeditor.editor.LdifOutlinePage;
import org.apache.directory.studio.utils.ActionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class LdifEntryEditor
extends LdifEditor
implements IEntryEditor,
IShowEditorInput {
    private static final String REFRESH_ACTION = "RefreshAction";
    private static final String FETCH_OPERATIONAL_ATTRIBUTES_ACTION = "FetchOperationalAttributesAction";
    private boolean inShowEditorInput = false;
    private IAction refreshAction = new Action(){

        public ImageDescriptor getImageDescriptor() {
            return BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/refresh.gif");
        }

        public String getText() {
            return Messages.getString((String)"RefreshAction.RelaodAttributes");
        }

        public boolean isEnabled() {
            return LdifEntryEditor.this.getEntryEditorInput().getResolvedEntry() != null;
        }

        public String getActionDefinitionId() {
            return "org.eclipse.ui.file.refresh";
        }

        public void run() {
            IEntry entry = LdifEntryEditor.this.getEntryEditorInput().getResolvedEntry();
            new StudioBrowserJob(new StudioRunnableWithProgress[]{new InitializeAttributesRunnable(new IEntry[]{entry})}).execute();
        }
    };
    private IAction fetchOperationalAttributesAction = new Action(){

        public int getStyle() {
            return 2;
        }

        public String getText() {
            return Messages.getString((String)"FetchOperationalAttributesAction.FetchOperationalAttributes");
        }

        public boolean isEnabled() {
            IEntry entry = LdifEntryEditor.this.getEntryEditorInput().getResolvedEntry();
            if (entry != null) {
                return !(entry = entry.getBrowserConnection().getEntryFromCache(entry.getDn())).getBrowserConnection().isFetchOperationalAttributes();
            }
            return false;
        }

        public void run() {
            IEntry entry = LdifEntryEditor.this.getEntryEditorInput().getResolvedEntry();
            boolean init = !(entry = entry.getBrowserConnection().getEntryFromCache(entry.getDn())).isInitOperationalAttributes();
            entry.setInitOperationalAttributes(init);
            new StudioBrowserJob(new StudioRunnableWithProgress[]{new InitializeAttributesRunnable(new IEntry[]{entry})}).execute();
        }
    };

    public LdifEntryEditor() {
        this.setDocumentProvider((IDocumentProvider)new LdifEntryEditorDocumentProvider(this));
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        IEntry entry = this.getEntryEditorInput().getResolvedEntry();
        if (entry != null) {
            this.setConnection(entry.getBrowserConnection());
        }
    }

    public void createPartControl(Composite parent) {
        this.showToolBar = false;
        super.createPartControl(parent);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        super.dispose();
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlinePage == null || this.outlinePage.getControl() == null || this.outlinePage.getControl().isDisposed()) {
                this.outlinePage = new LdifOutlinePage((LdifEditor)this, true);
            }
            return this.outlinePage;
        }
        return super.getAdapter(required);
    }

    protected void createActions() {
        super.createActions();
        this.setAction(REFRESH_ACTION, this.refreshAction);
        this.setAction(FETCH_OPERATIONAL_ATTRIBUTES_ACTION, this.fetchOperationalAttributesAction);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IEntry entry = this.getEntryEditorInput().getResolvedEntry();
        this.fetchOperationalAttributesAction.setChecked(entry != null ? entry.isInitOperationalAttributes() : false);
        this.addAction(menu, "group.rest", REFRESH_ACTION);
        this.addAction(menu, "group.rest", FETCH_OPERATIONAL_ATTRIBUTES_ACTION);
    }

    public void activateGlobalActionHandlers() {
        ActionUtils.activateActionHandler((IAction)this.refreshAction);
    }

    public void deactivateGlobalActionHandlers() {
        ActionUtils.deactivateActionHandler((IAction)this.refreshAction);
    }

    public INavigationLocation createNavigationLocation() {
        return new LdifEntryEditorNavigationLocation((ITextEditor)this, true);
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new LdifEntryEditorNavigationLocation((ITextEditor)this, false);
    }

    public boolean isAutoSave() {
        return false;
    }

    public boolean canHandle(IEntry entry) {
        return true;
    }

    public EntryEditorInput getEntryEditorInput() {
        return EntryEditorUtils.getEntryEditorInput(this.getEditorInput());
    }

    public void workingCopyModified(Object source) {
        ((LdifEntryEditorDocumentProvider)this.getDocumentProvider()).workingCopyModified(this.getEntryEditorInput(), source);
    }

    public void showEditorInput(IEditorInput input) {
        if (this.inShowEditorInput) {
            return;
        }
        try {
            this.inShowEditorInput = true;
            if (input instanceof EntryEditorInput) {
                EntryEditorInput eei = (EntryEditorInput)input;
                if (this.getEntryEditorInput() != null && this.getEntryEditorInput().getResolvedEntry() == eei.getResolvedEntry()) {
                    return;
                }
                if (this.isDirty() && !EntryEditorUtils.askSaveSharedWorkingCopyBeforeInputChange(this)) {
                    return;
                }
                IEntry entry = eei.getEntryInput();
                ISearchResult searchResult = eei.getSearchResultInput();
                IBookmark bookmark = eei.getBookmarkInput();
                EntryEditorInput dummyInput = entry != null ? new EntryEditorInput(entry, null) : (searchResult != null ? new EntryEditorInput(searchResult, null) : new EntryEditorInput(bookmark, null));
                this.doSetInput(dummyInput);
                this.firePropertyChange(258);
                this.doSetInput(input);
                this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.inShowEditorInput = false;
        }
    }
}

