/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.entry;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserLabelProvider;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditor;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class EntryEditorOutlinePage
extends ContentOutlinePage {
    private EntryEditor entryEditor;
    protected IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            EntryEditorOutlinePage.this.refresh();
        }
    };

    public EntryEditorOutlinePage(EntryEditor entryEditor) {
        this.entryEditor = entryEditor;
        BrowserCommonActivator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        final TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setLabelProvider((IBaseLabelProvider)new EntryEditorOutlineLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new EntryEditorOutlineContentProvider());
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o;
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection && (o = EntryEditorOutlinePage.this.entryEditor.getMainWidget().getViewer().getInput()) != null && o instanceof IEntry) {
                    ArrayList<Object> selectionList = new ArrayList<Object>();
                    for (Object element : ((IStructuredSelection)event.getSelection()).toArray()) {
                        if (element instanceof IValue) {
                            IValue value = (IValue)element;
                            selectionList.add(value);
                            continue;
                        }
                        if (element instanceof IAttribute) {
                            IAttribute attribute = (IAttribute)element;
                            selectionList.add(attribute);
                            selectionList.addAll(Arrays.asList(attribute.getValues()));
                            continue;
                        }
                        if (!(element instanceof EntryWrapper)) continue;
                        IEntry entry = ((EntryWrapper)element).entry;
                        for (IAttribute attribute : entry.getAttributes()) {
                            selectionList.add(attribute);
                            selectionList.addAll(Arrays.asList(attribute.getValues()));
                        }
                    }
                    StructuredSelection selection = new StructuredSelection(selectionList);
                    EntryEditorOutlinePage.this.entryEditor.getMainWidget().getViewer().setSelection((ISelection)selection);
                }
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (treeViewer.getExpandedState(obj)) {
                        treeViewer.collapseToLevel(obj, 1);
                    } else if (((ITreeContentProvider)treeViewer.getContentProvider()).hasChildren(obj)) {
                        treeViewer.expandToLevel(obj, 1);
                    }
                }
            }
        });
        this.refresh();
    }

    public void refresh(Object element) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && treeViewer.getTree() != null && !treeViewer.getTree().isDisposed()) {
            treeViewer.setFilters(this.entryEditor.getMainWidget().getViewer().getFilters());
            treeViewer.refresh(element);
        }
    }

    public void refresh() {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && treeViewer.getTree() != null && !treeViewer.getTree().isDisposed()) {
            treeViewer.setFilters(this.entryEditor.getMainWidget().getViewer().getFilters());
            if (!treeViewer.getTree().isEnabled()) {
                treeViewer.getTree().setEnabled(true);
            }
            if (this.entryEditor != null) {
                Object o = this.entryEditor.getMainWidget().getViewer().getInput();
                if (o == null) {
                    treeViewer.setInput(null);
                    treeViewer.getTree().setEnabled(false);
                } else if (o instanceof IEntry) {
                    treeViewer.setInput(o);
                    treeViewer.expandToLevel(2);
                }
            }
            treeViewer.refresh();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.entryEditor != null) {
            BrowserCommonActivator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.entryEditor = null;
        }
    }

    private static class EntryWrapper {
        IEntry entry;

        public EntryWrapper(IEntry entry) {
            this.entry = entry;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntryWrapper other = (EntryWrapper)obj;
            return !(this.entry == null ? other.entry != null : !this.entry.equals(other.entry));
        }
    }

    private static class EntryEditorOutlineLabelProvider
    extends LabelProvider {
        private EntryEditorOutlineLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof EntryWrapper) {
                IEntry entry = ((EntryWrapper)element).entry;
                if (entry.getDn() != null && "".equals(entry.getDn().toString())) {
                    return "Root DSE";
                }
                return entry.getDn().getUpName();
            }
            if (element instanceof IAttribute) {
                IAttribute attribute = (IAttribute)element;
                return attribute.getDescription() + " (" + attribute.getValueSize() + ")";
            }
            if (element instanceof IValue) {
                IValue value = (IValue)element;
                return Utils.getShortenedString((String)value.getStringValue(), (int)20);
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof EntryWrapper) {
                IEntry entry = ((EntryWrapper)element).entry;
                if (entry.getDn() != null && "".equals(entry.getDn().toString())) {
                    return BrowserCommonActivator.getDefault().getImage("resources/icons/entry_root.gif");
                }
                return BrowserLabelProvider.getImageByObjectClass((IEntry)entry);
            }
            if (element instanceof IAttribute) {
                return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_attribute.gif");
            }
            if (element instanceof IValue) {
                return LdifEditorActivator.getDefault().getImage("resources/icons/ldif_value.gif");
            }
            return null;
        }
    }

    private static class EntryEditorOutlineContentProvider
    implements ITreeContentProvider {
        private EntryEditorOutlineContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IEntry) {
                IEntry entry = (IEntry)element;
                return new EntryWrapper[]{new EntryWrapper(entry)};
            }
            if (element instanceof EntryWrapper) {
                EntryWrapper entryWrapper = (EntryWrapper)element;
                return entryWrapper.entry.getAttributes();
            }
            if (element instanceof IAttribute) {
                IAttribute attribute = (IAttribute)element;
                return attribute.getValues();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null && this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

