/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.properties;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.core.BrowserConnectionManager;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReloadSchemaRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.Messages;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.RootDSEPropertyPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class SchemaPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text dnText;
    private Text ctText;
    private Text mtText;
    private Button reloadSchemaButton;
    private Text cachePathText;
    private Text cacheDateText;
    private Text cacheSizeText;

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Group infoGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("SchemaPropertyPage.SchemaInformation"), (int)1);
        Composite infoComposite = BaseWidgetUtils.createColumnContainer((Composite)infoGroup, (int)2, (int)1);
        Composite infoGroupLeft = BaseWidgetUtils.createColumnContainer((Composite)infoComposite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)infoGroupLeft, (String)Messages.getString("SchemaPropertyPage.SchemaDN"), (int)1);
        this.dnText = BaseWidgetUtils.createWrappedLabeledText((Composite)infoGroupLeft, (String)"-", (int)1, (int)200);
        BaseWidgetUtils.createLabel((Composite)infoGroupLeft, (String)Messages.getString("SchemaPropertyPage.CreateTimestamp"), (int)1);
        this.ctText = BaseWidgetUtils.createWrappedLabeledText((Composite)infoGroupLeft, (String)"-", (int)1, (int)200);
        BaseWidgetUtils.createLabel((Composite)infoGroupLeft, (String)Messages.getString("SchemaPropertyPage.ModifyTimestamp"), (int)1);
        this.mtText = BaseWidgetUtils.createWrappedLabeledText((Composite)infoGroupLeft, (String)"-", (int)1, (int)200);
        this.reloadSchemaButton = BaseWidgetUtils.createButton((Composite)infoComposite, (String)"-", (int)1);
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        this.reloadSchemaButton.setLayoutData((Object)gd);
        this.reloadSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaPropertyPage.this.reloadSchema();
            }
        });
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group cacheGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("SchemaPropertyPage.SchemaCache"), (int)1);
        Composite cacheComposite = BaseWidgetUtils.createColumnContainer((Composite)cacheGroup, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)cacheComposite, (String)Messages.getString("SchemaPropertyPage.CacheLocation"), (int)1);
        this.cachePathText = BaseWidgetUtils.createWrappedLabeledText((Composite)cacheComposite, (String)"-", (int)1, (int)200);
        BaseWidgetUtils.createLabel((Composite)cacheComposite, (String)Messages.getString("SchemaPropertyPage.CacheDate"), (int)1);
        this.cacheDateText = BaseWidgetUtils.createWrappedLabeledText((Composite)cacheComposite, (String)"-", (int)1, (int)200);
        BaseWidgetUtils.createLabel((Composite)cacheComposite, (String)Messages.getString("SchemaPropertyPage.CacheSize"), (int)1);
        this.cacheSizeText = BaseWidgetUtils.createWrappedLabeledText((Composite)cacheComposite, (String)"-", (int)1, (int)200);
        IBrowserConnection connection = RootDSEPropertyPage.getConnection(this.getElement());
        this.update(connection);
        return composite;
    }

    private void reloadSchema() {
        IBrowserConnection browserConnection = RootDSEPropertyPage.getConnection(this.getElement());
        ReloadSchemaRunnable runnable = new ReloadSchemaRunnable(browserConnection);
        RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, null, (boolean)true);
        this.update(browserConnection);
    }

    private void update(IBrowserConnection browserConnection) {
        if (!this.dnText.isDisposed()) {
            Schema schema = null;
            if (browserConnection != null) {
                schema = browserConnection.getSchema();
            }
            if (schema != null && schema.getDn() != null) {
                this.dnText.setText(schema.getDn().toString());
            } else {
                this.dnText.setText("-");
            }
            if (schema != null && schema.getCreateTimestamp() != null) {
                this.ctText.setText(schema.getCreateTimestamp());
            } else {
                this.ctText.setText("-");
            }
            if (schema != null && schema.getModifyTimestamp() != null) {
                this.mtText.setText(schema.getModifyTimestamp());
            } else {
                this.mtText.setText("-");
            }
            if (schema != null) {
                this.reloadSchemaButton.setText(Messages.getString("SchemaPropertyPage.ReloadSchema"));
            } else {
                this.reloadSchemaButton.setText(Messages.getString("SchemaPropertyPage.LoadSchema"));
            }
            if (browserConnection != null) {
                String cacheFileName = BrowserConnectionManager.getSchemaCacheFileName((String)browserConnection.getConnection().getId());
                File cacheFile = new File(cacheFileName);
                if (cacheFile.exists()) {
                    this.cachePathText.setText(cacheFile.getPath());
                    DateFormat format = DateFormat.getDateTimeInstance(1, 2);
                    this.cacheDateText.setText(format.format(new Date(cacheFile.lastModified())));
                    this.cacheSizeText.setText(Utils.formatBytes((long)cacheFile.length()));
                } else {
                    this.cachePathText.setText("-");
                    this.cacheDateText.setText("-");
                    this.cacheSizeText.setText("-");
                }
            }
            this.reloadSchemaButton.setEnabled(true);
        }
    }

    public boolean isDisposed() {
        return this.dnText.isDisposed();
    }
}

