/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.properties;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class RootDSEPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private TabFolder tabFolder;
    private TabItem infoTab;
    private TabItem controlsTab;
    private TabItem extensionsTab;
    private TabItem featuresTab;

    static IBrowserConnection getConnection(Object element) {
        IBrowserConnection browserConnection = null;
        if (element instanceof IAdaptable && (browserConnection = (IBrowserConnection)((IAdaptable)element).getAdapter(IBrowserConnection.class)) == null) {
            Connection connection = (Connection)((IAdaptable)element).getAdapter(Connection.class);
            browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
        }
        return browserConnection;
    }

    protected Control createContents(Composite parent) {
        IBrowserConnection connection = RootDSEPropertyPage.getConnection(this.getElement());
        this.tabFolder = new TabFolder(parent, 128);
        RowLayout mainLayout = new RowLayout();
        mainLayout.fill = true;
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.tabFolder.setLayout((Layout)mainLayout);
        Composite infoComposite = new Composite((Composite)this.tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        infoComposite.setLayout((Layout)gl);
        BaseWidgetUtils.createLabel((Composite)infoComposite, (String)Messages.getString("RootDSEPropertyPage.DirectoryTypw"), (int)1);
        Text typeText = BaseWidgetUtils.createWrappedLabeledText((Composite)infoComposite, (String)"-", (int)1, (int)150);
        if (connection != null && connection.getRootDSE() != null) {
            IRootDSE rootDSE = connection.getRootDSE();
            String type = this.detectOpenLDAP(rootDSE);
            if (type == null && (type = this.detectSiemensDirX(rootDSE)) == null && (type = this.detectActiveDirectory(rootDSE)) == null) {
                type = this.detectByVendorName(rootDSE);
            }
            if (type != null) {
                typeText.setText(type);
            }
        }
        this.addInfo(connection, infoComposite, "vendorName", Messages.getString("RootDSEPropertyPage.VendorName"));
        this.addInfo(connection, infoComposite, "vendorVersion", Messages.getString("RootDSEPropertyPage.VendorVersion"));
        this.addInfo(connection, infoComposite, "supportedLDAPVersion", Messages.getString("RootDSEPropertyPage.SupportedLDAPVersion"));
        this.addInfo(connection, infoComposite, "supportedSASLMechanisms", Messages.getString("RootDSEPropertyPage.SupportedSASL"));
        this.infoTab = new TabItem(this.tabFolder, 0);
        this.infoTab.setText(Messages.getString("RootDSEPropertyPage.Info"));
        this.infoTab.setControl((Control)infoComposite);
        Composite controlsComposite = new Composite((Composite)this.tabFolder, 0);
        controlsComposite.setLayout((Layout)new GridLayout());
        Composite controlsComposite2 = BaseWidgetUtils.createColumnContainer((Composite)controlsComposite, (int)2, (int)1);
        this.addOidInfo(connection, controlsComposite2, "supportedControl");
        this.controlsTab = new TabItem(this.tabFolder, 0);
        this.controlsTab.setText(Messages.getString("RootDSEPropertyPage.Controls"));
        this.controlsTab.setControl((Control)controlsComposite);
        Composite extensionComposite = new Composite((Composite)this.tabFolder, 0);
        extensionComposite.setLayout((Layout)new GridLayout());
        Composite extensionComposite2 = BaseWidgetUtils.createColumnContainer((Composite)extensionComposite, (int)2, (int)1);
        this.addOidInfo(connection, extensionComposite2, "supportedExtension");
        this.extensionsTab = new TabItem(this.tabFolder, 0);
        this.extensionsTab.setText(Messages.getString("RootDSEPropertyPage.Extensions"));
        this.extensionsTab.setControl((Control)extensionComposite);
        Composite featureComposite = new Composite((Composite)this.tabFolder, 0);
        featureComposite.setLayout((Layout)new GridLayout());
        Composite featureComposite2 = BaseWidgetUtils.createColumnContainer((Composite)featureComposite, (int)2, (int)1);
        this.addOidInfo(connection, featureComposite2, "supportedFeatures");
        this.featuresTab = new TabItem(this.tabFolder, 0);
        this.featuresTab.setText(Messages.getString("RootDSEPropertyPage.Features"));
        this.featuresTab.setControl((Control)featureComposite);
        return this.tabFolder;
    }

    private String detectByVendorName(IRootDSE rootDSE) {
        String result = null;
        IAttribute vnAttribute = rootDSE.getAttribute("vendorName");
        IAttribute vvAttribute = rootDSE.getAttribute("vendorVersion");
        if (vnAttribute != null && vnAttribute.getStringValues().length > 0 && vvAttribute != null && vvAttribute.getStringValues().length > 0) {
            String vendorName = vnAttribute.getStringValues()[0];
            String vendorVersion = vvAttribute.getStringValues()[0];
            if (vendorName.indexOf("Apache Software Foundation") > -1) {
                result = Messages.getString("RootDSEPropertyPage.ApacheDirectoryServer");
            }
            if (vendorName.indexOf("Novell") > -1 || vendorVersion.indexOf("eDirectory") > -1) {
                result = Messages.getString("RootDSEPropertyPage.NovellEDirectory");
            }
            if (vendorName.indexOf("Sun") > -1 || vendorVersion.indexOf("Sun") > -1) {
                result = Messages.getString("RootDSEPropertyPage.SunDirectoryServer");
            }
            if (vendorName.indexOf("Netscape") > -1 || vendorVersion.indexOf("Netscape") > -1) {
                result = Messages.getString("RootDSEPropertyPage.NetscapeDirectoryServer");
            }
            if (vendorName.indexOf("International Business Machines") > -1) {
                String[] tdsVersions;
                String[] idsVersions;
                String[] iswVersions;
                for (String version : iswVersions = new String[]{"3.2", "3.2.1", "3.2.2"}) {
                    if (vendorVersion.indexOf(version) <= -1) continue;
                    result = Messages.getString("RootDSEPropertyPage.IBMSecureWay");
                }
                for (String version : idsVersions = new String[]{"4.1", "5.1"}) {
                    if (vendorVersion.indexOf(version) <= -1) continue;
                    result = Messages.getString("RootDSEPropertyPage.IBMDirectory");
                }
                for (String version : tdsVersions = new String[]{"5.2", "6.0", "6.1", "6.2"}) {
                    if (vendorVersion.indexOf(version) <= -1) continue;
                    result = Messages.getString("RootDSEPropertyPage.IBMTivoli");
                }
            }
        }
        return result;
    }

    private String detectActiveDirectory(IRootDSE rootDSE) {
        String result = null;
        IAttribute rdncAttribute = rootDSE.getAttribute("rootDomainNamingContext");
        if (rdncAttribute != null) {
            IAttribute ffAttribute = rootDSE.getAttribute("forestFunctionality");
            result = ffAttribute != null ? Messages.getString("RootDSEPropertyPage.MSAD2003") : Messages.getString("RootDSEPropertyPage.MSAD2000");
        }
        return result;
    }

    private String detectSiemensDirX(IRootDSE rootDSE) {
        String result = null;
        IAttribute ssseAttribute = rootDSE.getAttribute("subSchemaSubentry");
        if (ssseAttribute != null) {
            for (int i = 0; i < ssseAttribute.getStringValues().length; ++i) {
                if (!"cn=LDAPGlobalSchemaSubentry".equals(ssseAttribute.getStringValues()[i])) continue;
                result = Messages.getString("RootDSEPropertyPage.SiemesDirX");
            }
        }
        return result;
    }

    private String detectOpenLDAP(IRootDSE rootDSE) {
        String result = null;
        boolean typeDetected = false;
        IAttribute ocAttribute = rootDSE.getAttribute("objectClass");
        if (ocAttribute != null) {
            for (int i = 0; i < ocAttribute.getStringValues().length; ++i) {
                IAttribute sfAttribute;
                IAttribute seAttribute;
                IAttribute scAttribute;
                if (!"OpenLDAProotDSE".equals(ocAttribute.getStringValues()[i])) continue;
                IAttribute ccAttribute = rootDSE.getAttribute("configContext");
                if (ccAttribute != null) {
                    result = Messages.getString("RootDSEPropertyPage.openLDAP23");
                    typeDetected = true;
                }
                if (!typeDetected && (scAttribute = rootDSE.getAttribute("supportedControl")) != null) {
                    for (int sci = 0; sci < scAttribute.getStringValues().length; ++sci) {
                        if (!"2.16.840.1.113730.3.4.18".equals(scAttribute.getStringValues()[sci])) continue;
                        result = Messages.getString("RootDSEPropertyPage.OpenLDAP22");
                        typeDetected = true;
                    }
                }
                if (!typeDetected && (seAttribute = rootDSE.getAttribute("supportedExtension")) != null) {
                    for (int sei = 0; sei < seAttribute.getStringValues().length; ++sei) {
                        if (!"1.3.6.1.4.1.4203.1.11.3".equals(seAttribute.getStringValues()[sei])) continue;
                        result = Messages.getString("RootDSEPropertyPage.OpenLDAP21");
                        typeDetected = true;
                    }
                }
                if (!typeDetected && (sfAttribute = rootDSE.getAttribute("supportedFeatures")) != null) {
                    for (int sfi = 0; sfi < sfAttribute.getStringValues().length; ++sfi) {
                        if (!"1.3.6.1.4.1.4203.1.5.4".equals(sfAttribute.getStringValues()[sfi])) continue;
                        result = Messages.getString("RootDSEPropertyPage.OpenLDAP20");
                        typeDetected = true;
                    }
                }
                if (typeDetected) continue;
                result = Messages.getString("RootDSEPropertyPage.OpenLDAP");
                typeDetected = true;
            }
        }
        return result;
    }

    private void addOidInfo(IBrowserConnection browserConnection, Composite composite, String attributeType) {
        try {
            String[] values;
            for (String value : values = browserConnection.getRootDSE().getAttribute(attributeType).getStringValues()) {
                String description = Utils.getOidDescription((String)value);
                if (description == null) {
                    description = "";
                }
                BaseWidgetUtils.createLabeledText((Composite)composite, (String)value, (int)1, (int)15);
                BaseWidgetUtils.createLabeledText((Composite)composite, (String)description, (int)1, (int)15);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void addInfo(IBrowserConnection browserConnection, Composite composite, String attributeType, String labelName) {
        StringBuffer sb = new StringBuffer();
        try {
            String[] values = browserConnection.getRootDSE().getAttribute(attributeType).getStringValues();
            boolean isFirst = true;
            for (String value : values) {
                if (!isFirst) {
                    sb.append(BrowserCoreConstants.LINE_SEPARATOR);
                }
                sb.append(value);
                isFirst = false;
            }
        }
        catch (Exception e) {
            sb.append(Messages.getString("RootDSEPropertyPage.Dash"));
        }
        BaseWidgetUtils.createLabel((Composite)composite, (String)labelName, (int)1);
        BaseWidgetUtils.createWrappedLabeledText((Composite)composite, (String)sb.toString(), (int)1, (int)150);
    }
}

