/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.properties;

import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeChildrenRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class EntryPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text dnText;
    private Text urlText;
    private Text ctText;
    private Text cnText;
    private Text mtText;
    private Text mnText;
    private Button reloadCmiButton;
    private Text sizeText;
    private Text childrenText;
    private Text attributesText;
    private Text valuesText;
    private Button includeOperationalAttributesButton;
    private Button reloadEntryButton;

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Composite mainGroup = BaseWidgetUtils.createColumnContainer((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)mainGroup, (String)Messages.getString("EntryPropertyPage.DN"), (int)1);
        this.dnText = BaseWidgetUtils.createWrappedLabeledText((Composite)mainGroup, (String)"", (int)1);
        GridData dnTextGridData = new GridData(4, 0, true, false);
        dnTextGridData.widthHint = 300;
        this.dnText.setLayoutData((Object)dnTextGridData);
        BaseWidgetUtils.createLabel((Composite)mainGroup, (String)Messages.getString("EntryPropertyPage.URL"), (int)1);
        this.urlText = BaseWidgetUtils.createWrappedLabeledText((Composite)mainGroup, (String)"", (int)1);
        GridData urlTextGridData = new GridData(4, 0, true, false);
        urlTextGridData.widthHint = 300;
        this.urlText.setLayoutData((Object)urlTextGridData);
        Group cmiGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("EntryPropertyPage.CreateModifyinformation"), (int)1);
        Composite cmiComposite = BaseWidgetUtils.createColumnContainer((Composite)cmiGroup, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)cmiComposite, (String)Messages.getString("EntryPropertyPage.CreateTimestamp"), (int)1);
        this.ctText = BaseWidgetUtils.createLabeledText((Composite)cmiComposite, (String)"", (int)2);
        GridData ctTextGridData = new GridData(4, 0, true, false, 2, 1);
        ctTextGridData.widthHint = 300;
        this.ctText.setLayoutData((Object)ctTextGridData);
        BaseWidgetUtils.createLabel((Composite)cmiComposite, (String)Messages.getString("EntryPropertyPage.CreatorsName"), (int)1);
        this.cnText = BaseWidgetUtils.createLabeledText((Composite)cmiComposite, (String)"", (int)2);
        GridData cnTextGridData = new GridData(4, 0, true, false, 2, 1);
        cnTextGridData.widthHint = 300;
        this.cnText.setLayoutData((Object)cnTextGridData);
        BaseWidgetUtils.createLabel((Composite)cmiComposite, (String)Messages.getString("EntryPropertyPage.ModifyTimestamp"), (int)1);
        this.mtText = BaseWidgetUtils.createLabeledText((Composite)cmiComposite, (String)"", (int)2);
        GridData mtTextGridData = new GridData(4, 0, true, false, 2, 1);
        mtTextGridData.widthHint = 300;
        this.mtText.setLayoutData((Object)mtTextGridData);
        BaseWidgetUtils.createLabel((Composite)cmiComposite, (String)Messages.getString("EntryPropertyPage.ModifiersName"), (int)1);
        this.mnText = BaseWidgetUtils.createLabeledText((Composite)cmiComposite, (String)"", (int)1);
        GridData mnTextGridData = new GridData(768);
        mnTextGridData.widthHint = 300;
        this.mnText.setLayoutData((Object)mnTextGridData);
        this.reloadCmiButton = BaseWidgetUtils.createButton((Composite)cmiComposite, (String)"", (int)1);
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 131072;
        this.reloadCmiButton.setLayoutData((Object)gd);
        this.reloadCmiButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntryPropertyPage.this.reloadOperationalAttributes();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group sizingGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("EntryPropertyPage.SizingInformation"), (int)1);
        Composite sizingComposite = BaseWidgetUtils.createColumnContainer((Composite)sizingGroup, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)sizingComposite, (String)Messages.getString("EntryPropertyPage.EntrySize"), (int)1);
        this.sizeText = BaseWidgetUtils.createLabeledText((Composite)sizingComposite, (String)"", (int)2);
        GridData sizeTextGridData = new GridData(4, 0, true, false, 2, 1);
        sizeTextGridData.widthHint = 300;
        this.sizeText.setLayoutData((Object)sizeTextGridData);
        BaseWidgetUtils.createLabel((Composite)sizingComposite, (String)Messages.getString("EntryPropertyPage.NumberOfChildren"), (int)1);
        this.childrenText = BaseWidgetUtils.createLabeledText((Composite)sizingComposite, (String)"", (int)2);
        GridData childrenTextGridData = new GridData(4, 0, true, false, 2, 1);
        childrenTextGridData.widthHint = 300;
        this.childrenText.setLayoutData((Object)childrenTextGridData);
        BaseWidgetUtils.createLabel((Composite)sizingComposite, (String)Messages.getString("EntryPropertyPage.NumberOfAttributes"), (int)1);
        this.attributesText = BaseWidgetUtils.createLabeledText((Composite)sizingComposite, (String)"", (int)2);
        GridData attributesTextGridData = new GridData(4, 0, true, false, 2, 1);
        attributesTextGridData.widthHint = 300;
        this.attributesText.setLayoutData((Object)attributesTextGridData);
        BaseWidgetUtils.createLabel((Composite)sizingComposite, (String)Messages.getString("EntryPropertyPage.NumberOfValues"), (int)1);
        this.valuesText = BaseWidgetUtils.createLabeledText((Composite)sizingComposite, (String)"", (int)2);
        GridData valuesTextGridData = new GridData(4, 0, true, false, 2, 1);
        valuesTextGridData.widthHint = 300;
        this.valuesText.setLayoutData((Object)valuesTextGridData);
        this.includeOperationalAttributesButton = BaseWidgetUtils.createCheckbox((Composite)sizingComposite, (String)Messages.getString("EntryPropertyPage.IncludeoperationalAttributes"), (int)2);
        this.includeOperationalAttributesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntryPropertyPage.this.entryUpdated(EntryPropertyPage.getEntry(EntryPropertyPage.this.getElement()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.reloadEntryButton = BaseWidgetUtils.createButton((Composite)sizingComposite, (String)"", (int)1);
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 131072;
        this.reloadEntryButton.setLayoutData((Object)gd);
        this.reloadEntryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntryPropertyPage.this.reloadEntry();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.entryUpdated(EntryPropertyPage.getEntry(this.getElement()));
        return composite;
    }

    private void reloadOperationalAttributes() {
        IEntry entry = EntryPropertyPage.getEntry(this.getElement());
        entry.setInitOperationalAttributes(true);
        InitializeAttributesRunnable runnable = new InitializeAttributesRunnable(new IEntry[]{entry});
        RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, null, (boolean)true);
        this.entryUpdated(entry);
    }

    private void reloadEntry() {
        IEntry entry = EntryPropertyPage.getEntry(this.getElement());
        entry.setInitOperationalAttributes(true);
        InitializeChildrenRunnable runnable1 = new InitializeChildrenRunnable(false, new IEntry[]{entry});
        InitializeAttributesRunnable runnable2 = new InitializeAttributesRunnable(new IEntry[]{entry});
        RunnableContextRunner.execute((StudioRunnableWithProgress)runnable1, null, (boolean)true);
        RunnableContextRunner.execute((StudioRunnableWithProgress)runnable2, null, (boolean)true);
        this.entryUpdated(entry);
    }

    static IEntry getEntry(Object element) {
        IEntry entry = null;
        if (element instanceof IAdaptable) {
            entry = (IEntry)((IAdaptable)element).getAdapter(IEntry.class);
        }
        return entry;
    }

    public boolean isDisposed() {
        return this.dnText.isDisposed();
    }

    private String getNonNullStringValue(IAttribute att) {
        String value = null;
        if (att != null) {
            value = att.getStringValue();
        }
        return value != null ? value : "-";
    }

    private void entryUpdated(IEntry entry) {
        if (!this.dnText.isDisposed()) {
            this.setMessage(Messages.getString("EntryPropertyPage.Entry") + entry.getDn().getUpName());
            this.dnText.setText(entry.getDn().getUpName());
            this.urlText.setText(entry.getUrl().toString());
            this.ctText.setText(this.getNonNullStringValue(entry.getAttribute("createTimestamp")));
            this.cnText.setText(this.getNonNullStringValue(entry.getAttribute("creatorsName")));
            this.mtText.setText(this.getNonNullStringValue(entry.getAttribute("modifyTimestamp")));
            this.mnText.setText(this.getNonNullStringValue(entry.getAttribute("modifiersName")));
            this.reloadCmiButton.setText(Messages.getString("EntryPropertyPage.Refresh"));
            int attCount = 0;
            int valCount = 0;
            int bytes = 0;
            IAttribute[] allAttributes = entry.getAttributes();
            if (allAttributes != null) {
                for (int attIndex = 0; attIndex < allAttributes.length; ++attIndex) {
                    if (allAttributes[attIndex].isOperationalAttribute() && !this.includeOperationalAttributesButton.getSelection()) continue;
                    ++attCount;
                    IValue[] allValues = allAttributes[attIndex].getValues();
                    for (int valIndex = 0; valIndex < allValues.length; ++valIndex) {
                        if (allValues[valIndex].isEmpty()) continue;
                        ++valCount;
                        bytes += allValues[valIndex].getBinaryValue().length;
                    }
                }
            }
            this.reloadEntryButton.setText(Messages.getString("EntryPropertyPage.Refresh"));
            if (!entry.isChildrenInitialized()) {
                this.childrenText.setText(Messages.getString("EntryPropertyPage.NotChecked"));
            } else {
                this.childrenText.setText(entry.hasMoreChildren() ? NLS.bind((String)Messages.getString("EntryPropertyPage.ChildrenFetched"), (Object[])new Object[]{entry.getChildrenCount()}) : Integer.toString(entry.getChildrenCount()));
            }
            this.attributesText.setText("" + attCount);
            this.valuesText.setText("" + valCount);
            this.sizeText.setText(Utils.formatBytes((long)bytes));
        }
    }
}

