/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.properties;

import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.EntryWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class BookmarkPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private IBookmark bookmark;
    private Text bookmarkNameText;
    private EntryWidget bookmarkEntryWidget;

    protected Control createContents(Composite parent) {
        if (this.getElement() instanceof IAdaptable) {
            this.bookmark = (IBookmark)this.getElement().getAdapter(IBookmark.class);
            super.setMessage(Messages.getString("BookmarkPropertyPage.Bookmark") + Utils.shorten((String)this.bookmark.getName(), (int)30));
        } else {
            this.bookmark = null;
        }
        Composite innerComposite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)innerComposite, (String)Messages.getString("BookmarkPropertyPage.BookmarkName"), (int)1);
        this.bookmarkNameText = BaseWidgetUtils.createText((Composite)innerComposite, (String)(this.bookmark != null ? this.bookmark.getName() : ""), (int)2);
        this.bookmarkNameText.setFocus();
        this.bookmarkNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BookmarkPropertyPage.this.validate();
            }
        });
        BaseWidgetUtils.createLabel((Composite)innerComposite, (String)Messages.getString("BookmarkPropertyPage.BookmarkDN"), (int)1);
        this.bookmarkEntryWidget = new EntryWidget();
        this.bookmarkEntryWidget.createWidget(innerComposite);
        if (this.bookmark != null) {
            this.bookmarkEntryWidget.setInput(this.bookmark.getBrowserConnection(), this.bookmark.getDn());
        }
        this.bookmarkEntryWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                BookmarkPropertyPage.this.validate();
            }
        });
        return innerComposite;
    }

    public boolean performOk() {
        if (this.bookmark != null) {
            this.bookmark.setName(this.bookmarkNameText.getText());
            this.bookmark.setDn(this.bookmarkEntryWidget.getDn());
            this.bookmarkEntryWidget.saveDialogSettings();
        }
        return true;
    }

    private void validate() {
        this.setValid(this.bookmarkEntryWidget.getDn() != null && !"".equals(this.bookmarkNameText.getText()));
        if (this.bookmark != null) {
            if (this.bookmarkEntryWidget.getDn() == null) {
                this.setValid(false);
                this.setErrorMessage(Messages.getString("BookmarkPropertyPage.EnterDN"));
            } else if ("".equals(this.bookmarkNameText.getText())) {
                this.setValid(false);
                this.setErrorMessage(Messages.getString("BookmarkPropertyPage.EnterName"));
            } else if (!this.bookmark.getName().equals(this.bookmarkNameText.getText()) && this.bookmark.getBrowserConnection().getBookmarkManager().getBookmark(this.bookmarkNameText.getText()) != null) {
                this.setValid(false);
                this.setErrorMessage(Messages.getString("BookmarkPropertyPage.ErrorBookmarkExists"));
            } else {
                this.setValid(true);
                this.setErrorMessage(null);
            }
        } else {
            this.setValid(false);
        }
    }
}

