/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.properties;

import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class AttributePropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text attributeNameText;
    private Text attributeTypeText;
    private Text attributeValuesText;
    private Text attributeSizeText;
    private Text atdOidText;
    private Text atdNamesText;
    private Text atdDescText;
    private Text atdUsageText;
    private Button singleValuedFlag;
    private Button collectiveFlag;
    private Button obsoleteFlag;
    private Button noUserModificationFlag;
    private Text equalityMatchingRuleText;
    private Text substringMatchingRuleText;
    private Text orderingMatchingRuleText;
    private Text syntaxOidText;
    private Text syntaxDescText;
    private Text syntaxLengthText;

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Composite mainGroup = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)mainGroup, (String)Messages.getString("AttributePropertyPage.Description"), (int)1);
        this.attributeNameText = BaseWidgetUtils.createLabeledText((Composite)mainGroup, (String)"", (int)1);
        GridData attributeNameTextGridData = new GridData(4, 0, true, false);
        attributeNameTextGridData.widthHint = 300;
        this.attributeNameText.setLayoutData((Object)attributeNameTextGridData);
        BaseWidgetUtils.createLabel((Composite)mainGroup, (String)Messages.getString("AttributePropertyPage.Type"), (int)1);
        this.attributeTypeText = BaseWidgetUtils.createLabeledText((Composite)mainGroup, (String)"", (int)1);
        GridData attributeTypeTextGridData = new GridData(4, 0, true, false);
        attributeTypeTextGridData.widthHint = 300;
        this.attributeTypeText.setLayoutData((Object)attributeTypeTextGridData);
        BaseWidgetUtils.createLabel((Composite)mainGroup, (String)Messages.getString("AttributePropertyPage.NumberOfValues"), (int)1);
        this.attributeValuesText = BaseWidgetUtils.createLabeledText((Composite)mainGroup, (String)"", (int)1);
        GridData attributeValuesTextGridData = new GridData(4, 0, true, false);
        attributeValuesTextGridData.widthHint = 300;
        this.attributeValuesText.setLayoutData((Object)attributeValuesTextGridData);
        BaseWidgetUtils.createLabel((Composite)mainGroup, (String)Messages.getString("AttributePropertyPage.AttributeSize"), (int)1);
        this.attributeSizeText = BaseWidgetUtils.createLabeledText((Composite)mainGroup, (String)"", (int)1);
        GridData attributeSizeTextGridData = new GridData(4, 0, true, false);
        attributeSizeTextGridData.widthHint = 300;
        this.attributeSizeText.setLayoutData((Object)attributeSizeTextGridData);
        Group atdGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("AttributePropertyPage.AttributeType"), (int)1);
        Composite atdComposite = BaseWidgetUtils.createColumnContainer((Composite)atdGroup, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)atdComposite, (String)Messages.getString("AttributePropertyPage.NubericOID"), (int)1);
        this.atdOidText = BaseWidgetUtils.createLabeledText((Composite)atdComposite, (String)"", (int)1);
        GridData atdOidTextGridData = new GridData(4, 0, true, false);
        atdOidTextGridData.widthHint = 300;
        this.atdOidText.setLayoutData((Object)atdOidTextGridData);
        BaseWidgetUtils.createLabel((Composite)atdComposite, (String)Messages.getString("AttributePropertyPage.AlternativeNames"), (int)1);
        this.atdNamesText = BaseWidgetUtils.createLabeledText((Composite)atdComposite, (String)"", (int)1);
        GridData atdNamesTextGridData = new GridData(4, 0, true, false);
        atdNamesTextGridData.widthHint = 300;
        this.atdNamesText.setLayoutData((Object)atdNamesTextGridData);
        BaseWidgetUtils.createLabel((Composite)atdComposite, (String)Messages.getString("AttributePropertyPage.Description"), (int)1);
        this.atdDescText = BaseWidgetUtils.createWrappedLabeledText((Composite)atdComposite, (String)"", (int)1);
        GridData atdDescTextGridData = new GridData(4, 0, true, false);
        atdDescTextGridData.widthHint = 300;
        this.atdDescText.setLayoutData((Object)atdDescTextGridData);
        BaseWidgetUtils.createLabel((Composite)atdComposite, (String)Messages.getString("AttributePropertyPage.Usage"), (int)1);
        this.atdUsageText = BaseWidgetUtils.createLabeledText((Composite)atdComposite, (String)"", (int)1);
        GridData atdUsageTextGridData = new GridData(4, 0, true, false);
        atdUsageTextGridData.widthHint = 300;
        this.atdUsageText.setLayoutData((Object)atdUsageTextGridData);
        Group flagsGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("AttributePropertyPage.Flags"), (int)1);
        Composite flagsComposite = BaseWidgetUtils.createColumnContainer((Composite)flagsGroup, (int)4, (int)1);
        this.singleValuedFlag = BaseWidgetUtils.createCheckbox((Composite)flagsComposite, (String)Messages.getString("AttributePropertyPage.SingleValued"), (int)1);
        this.singleValuedFlag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributePropertyPage.this.singleValuedFlag.setSelection(!AttributePropertyPage.this.singleValuedFlag.getSelection());
            }
        });
        this.noUserModificationFlag = BaseWidgetUtils.createCheckbox((Composite)flagsComposite, (String)Messages.getString("AttributePropertyPage.ReadOnly"), (int)1);
        this.noUserModificationFlag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributePropertyPage.this.noUserModificationFlag.setSelection(!AttributePropertyPage.this.noUserModificationFlag.getSelection());
            }
        });
        this.collectiveFlag = BaseWidgetUtils.createCheckbox((Composite)flagsComposite, (String)Messages.getString("AttributePropertyPage.Collective"), (int)1);
        this.collectiveFlag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributePropertyPage.this.collectiveFlag.setSelection(!AttributePropertyPage.this.collectiveFlag.getSelection());
            }
        });
        this.obsoleteFlag = BaseWidgetUtils.createCheckbox((Composite)flagsComposite, (String)Messages.getString("AttributePropertyPage.Obsolete"), (int)1);
        this.obsoleteFlag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributePropertyPage.this.obsoleteFlag.setSelection(!AttributePropertyPage.this.obsoleteFlag.getSelection());
            }
        });
        Group syntaxGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("AttributePropertyPage.Syntax"), (int)1);
        Composite syntaxComposite = BaseWidgetUtils.createColumnContainer((Composite)syntaxGroup, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)syntaxComposite, (String)Messages.getString("AttributePropertyPage.SyntaxOID"), (int)1);
        this.syntaxOidText = BaseWidgetUtils.createLabeledText((Composite)syntaxComposite, (String)"", (int)1);
        GridData syntaxOidTextGridData = new GridData(4, 0, true, false);
        syntaxOidTextGridData.widthHint = 300;
        this.syntaxOidText.setLayoutData((Object)syntaxOidTextGridData);
        BaseWidgetUtils.createLabel((Composite)syntaxComposite, (String)Messages.getString("AttributePropertyPage.SyntaxDescription"), (int)1);
        this.syntaxDescText = BaseWidgetUtils.createLabeledText((Composite)syntaxComposite, (String)"", (int)1);
        GridData syntaxDescTextGridData = new GridData(4, 0, true, false);
        syntaxDescTextGridData.widthHint = 300;
        this.syntaxDescText.setLayoutData((Object)syntaxDescTextGridData);
        BaseWidgetUtils.createLabel((Composite)syntaxComposite, (String)Messages.getString("AttributePropertyPage.SyntaxLength"), (int)1);
        this.syntaxLengthText = BaseWidgetUtils.createLabeledText((Composite)syntaxComposite, (String)"", (int)1);
        GridData syntaxLengthTextGridData = new GridData(4, 0, true, false);
        syntaxLengthTextGridData.widthHint = 300;
        this.syntaxLengthText.setLayoutData((Object)syntaxLengthTextGridData);
        Group matchingGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("AttributePropertyPage.MatchingRules"), (int)1);
        Composite matchingComposite = BaseWidgetUtils.createColumnContainer((Composite)matchingGroup, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)matchingComposite, (String)Messages.getString("AttributePropertyPage.EqualityMatch"), (int)1);
        this.equalityMatchingRuleText = BaseWidgetUtils.createLabeledText((Composite)matchingComposite, (String)"", (int)1);
        GridData equalityMatchingRuleTextGridData = new GridData(4, 0, true, false);
        equalityMatchingRuleTextGridData.widthHint = 300;
        this.equalityMatchingRuleText.setLayoutData((Object)equalityMatchingRuleTextGridData);
        BaseWidgetUtils.createLabel((Composite)matchingComposite, (String)Messages.getString("AttributePropertyPage.SubstringMatch"), (int)1);
        this.substringMatchingRuleText = BaseWidgetUtils.createLabeledText((Composite)matchingComposite, (String)"", (int)1);
        GridData substringMatchingRuleTextGridData = new GridData(4, 0, true, false);
        substringMatchingRuleTextGridData.widthHint = 300;
        this.substringMatchingRuleText.setLayoutData((Object)substringMatchingRuleTextGridData);
        BaseWidgetUtils.createLabel((Composite)matchingComposite, (String)Messages.getString("AttributePropertyPage.OrderingMatch"), (int)1);
        this.orderingMatchingRuleText = BaseWidgetUtils.createLabeledText((Composite)matchingComposite, (String)"", (int)1);
        GridData orderingMatchingRuleTextGridData = new GridData(4, 0, true, false);
        orderingMatchingRuleTextGridData.widthHint = 300;
        this.orderingMatchingRuleText.setLayoutData((Object)orderingMatchingRuleTextGridData);
        IAttribute attribute = AttributePropertyPage.getAttribute(this.getElement());
        if (attribute != null) {
            Schema schema = attribute.getEntry().getBrowserConnection().getSchema();
            int bytes = 0;
            int valCount = 0;
            IValue[] allValues = attribute.getValues();
            for (int valIndex = 0; valIndex < allValues.length; ++valIndex) {
                if (allValues[valIndex].isEmpty()) continue;
                ++valCount;
                bytes += allValues[valIndex].getBinaryValue().length;
            }
            this.setMessage(NLS.bind((String)Messages.getString("AttributePropertyPage.Attribute"), (Object[])new String[]{attribute.getDescription()}));
            this.attributeNameText.setText(attribute.getDescription());
            this.attributeTypeText.setText(attribute.isString() ? "String" : "Binary");
            this.attributeValuesText.setText("" + valCount);
            this.attributeSizeText.setText(Utils.formatBytes((long)bytes));
            if (schema.hasAttributeTypeDescription(attribute.getDescription())) {
                AttributeTypeDescription atd = schema.getAttributeTypeDescription(attribute.getDescription());
                this.atdOidText.setText(atd.getNumericOid());
                String atdNames = atd.getNames().toString();
                this.atdNamesText.setText(atdNames.substring(1, atdNames.length() - 1));
                this.atdDescText.setText(Utils.getNonNullString((Object)atd.getDescription()));
                this.atdUsageText.setText(Utils.getNonNullString((Object)atd.getUsage()));
                this.singleValuedFlag.setSelection(atd.isSingleValued());
                this.noUserModificationFlag.setSelection(!atd.isUserModifiable());
                this.collectiveFlag.setSelection(atd.isCollective());
                this.obsoleteFlag.setSelection(atd.isObsolete());
                String syntaxNumericOid = SchemaUtils.getSyntaxNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema);
                int syntaxLength = SchemaUtils.getSyntaxLengthTransitive((AttributeTypeDescription)atd, (Schema)schema);
                String syntaxDescription = syntaxNumericOid != null ? schema.getLdapSyntaxDescription(syntaxNumericOid).getDescription() : null;
                this.syntaxOidText.setText(Utils.getNonNullString((Object)syntaxNumericOid));
                this.syntaxDescText.setText(Utils.getNonNullString((Object)syntaxDescription));
                this.syntaxLengthText.setText(Utils.getNonNullString((Object)(syntaxLength > 0 ? Integer.toString(syntaxLength) : null)));
                this.equalityMatchingRuleText.setText(Utils.getNonNullString((Object)SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema)));
                this.substringMatchingRuleText.setText(Utils.getNonNullString((Object)SchemaUtils.getSubstringMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema)));
                this.orderingMatchingRuleText.setText(Utils.getNonNullString((Object)SchemaUtils.getOrderingMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema)));
            }
        }
        return parent;
    }

    private static IAttribute getAttribute(Object element) {
        IAttribute attribute = null;
        if (element instanceof IAdaptable) {
            attribute = (IAttribute)((IAdaptable)element).getAdapter(IAttribute.class);
        }
        return attribute;
    }
}

