/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs;

import org.apache.directory.studio.connection.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.Messages;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EncoderDecoderDialog
extends Dialog {
    private Text iso88591Text;
    private Text iso88591HexText;
    private Text utf8Text;
    private Text utf8HexText;
    private Text base64Text;
    private Text errorText;
    private boolean inModify = false;

    public EncoderDecoderDialog(Shell parentShell) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("EncoderDecoderDialog.LDAPEncodeDecoder"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite2 = (Composite)super.createDialogArea(parent);
        GridData gd1 = new GridData(1808);
        gd1.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd1.heightHint = this.convertVerticalDLUsToPixels(300);
        composite2.setLayoutData((Object)gd1);
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)composite2, (int)2, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Label iso8859Label = new Label(composite, 0);
        iso8859Label.setText(Messages.getString("EncoderDecoderDialog.ISOColon"));
        this.iso88591Text = new Text(composite, 2816);
        GridData gd = new GridData(1808);
        this.iso88591Text.setLayoutData((Object)gd);
        Label iso8859HexLabel = new Label(composite, 0);
        iso8859HexLabel.setText(Messages.getString("EncoderDecoderDialog.ISOHex"));
        this.iso88591HexText = new Text(composite, 2056);
        this.iso88591HexText.setLayoutData((Object)new GridData(768));
        Label utf8Label = new Label(composite, 0);
        utf8Label.setText(Messages.getString("EncoderDecoderDialog.UTF"));
        this.utf8Text = new Text(composite, 2048);
        this.utf8Text.setLayoutData((Object)new GridData(768));
        Label utf8HexLabel = new Label(composite, 0);
        utf8HexLabel.setText(Messages.getString("EncoderDecoderDialog.UTFHex"));
        this.utf8HexText = new Text(composite, 2056);
        this.utf8HexText.setLayoutData((Object)new GridData(768));
        Label base64Label = new Label(composite, 0);
        base64Label.setText(Messages.getString("EncoderDecoderDialog.BASE"));
        this.base64Text = new Text(composite, 2048);
        this.base64Text.setLayoutData((Object)new GridData(768));
        this.errorText = new Text(composite, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.errorText.setLayoutData((Object)gd);
        this.iso88591Text.addModifyListener(new ModifyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifyText(ModifyEvent e) {
                if (!EncoderDecoderDialog.this.inModify) {
                    EncoderDecoderDialog.this.inModify = true;
                    try {
                        String iso = EncoderDecoderDialog.this.iso88591Text.getText();
                        byte[] isoHex = iso.getBytes("ISO-8859-1");
                        byte[] utf8 = LdifUtils.utf8encode((String)iso);
                        String utf8String = new String(utf8, "ISO-8859-1");
                        String base64 = LdifUtils.base64encode((byte[])utf8);
                        EncoderDecoderDialog.this.iso88591HexText.setText(LdifUtils.hexEncode((byte[])isoHex));
                        EncoderDecoderDialog.this.utf8Text.setText(utf8String);
                        EncoderDecoderDialog.this.utf8HexText.setText(LdifUtils.hexEncode((byte[])utf8));
                        EncoderDecoderDialog.this.base64Text.setText(base64);
                        EncoderDecoderDialog.this.errorText.setText("");
                    }
                    catch (Exception ex) {
                        EncoderDecoderDialog.this.errorText.setText(ex.getMessage());
                        ex.printStackTrace();
                    }
                    finally {
                        EncoderDecoderDialog.this.inModify = false;
                    }
                }
            }
        });
        this.utf8Text.addModifyListener(new ModifyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifyText(ModifyEvent e) {
                if (!EncoderDecoderDialog.this.inModify) {
                    EncoderDecoderDialog.this.inModify = true;
                    try {
                        String utf8String = EncoderDecoderDialog.this.utf8Text.getText();
                        byte[] utf8 = utf8String.getBytes("ISO-8859-1");
                        String iso = LdifUtils.utf8decode((byte[])utf8);
                        byte[] isoHex = iso.getBytes("ISO-8859-1");
                        String base64 = LdifUtils.base64encode((byte[])utf8);
                        EncoderDecoderDialog.this.iso88591Text.setText(iso);
                        EncoderDecoderDialog.this.iso88591HexText.setText(LdifUtils.hexEncode((byte[])isoHex));
                        EncoderDecoderDialog.this.utf8HexText.setText(LdifUtils.hexEncode((byte[])utf8));
                        EncoderDecoderDialog.this.base64Text.setText(base64);
                        EncoderDecoderDialog.this.errorText.setText("");
                    }
                    catch (Exception ex) {
                        EncoderDecoderDialog.this.errorText.setText(ex.getMessage());
                        ex.printStackTrace();
                    }
                    finally {
                        EncoderDecoderDialog.this.inModify = false;
                    }
                }
            }
        });
        this.base64Text.addModifyListener(new ModifyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifyText(ModifyEvent e) {
                if (!EncoderDecoderDialog.this.inModify) {
                    EncoderDecoderDialog.this.inModify = true;
                    try {
                        String base64 = EncoderDecoderDialog.this.base64Text.getText();
                        byte[] utf8 = LdifUtils.base64decodeToByteArray((String)base64);
                        String utf8String = new String(utf8, "ISO-8859-1");
                        String iso = LdifUtils.utf8decode((byte[])utf8);
                        byte[] isoHex = iso.getBytes("ISO-8859-1");
                        EncoderDecoderDialog.this.iso88591Text.setText(iso);
                        EncoderDecoderDialog.this.iso88591HexText.setText(LdifUtils.hexEncode((byte[])isoHex));
                        EncoderDecoderDialog.this.utf8Text.setText(utf8String);
                        EncoderDecoderDialog.this.utf8HexText.setText(LdifUtils.hexEncode((byte[])utf8));
                        EncoderDecoderDialog.this.errorText.setText("");
                    }
                    catch (Exception ex) {
                        EncoderDecoderDialog.this.errorText.setText(ex.getMessage());
                        ex.printStackTrace();
                    }
                    finally {
                        EncoderDecoderDialog.this.inModify = false;
                    }
                }
            }
        });
        return composite;
    }
}

