/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowserManager;
import org.eclipse.jface.resource.ImageDescriptor;

public class OpenSchemaBrowserAction
extends BrowserAction {
    public static final int MODE_NONE = 0;
    public static final int MODE_OBJECTCLASS = 10;
    public static final int MODE_ATTRIBUTETYPE = 20;
    public static final int MODE_EQUALITYMATCHINGRULE = 30;
    public static final int MODE_SUBSTRINGMATCHINGRULE = 31;
    public static final int MODE_ORDERINGMATCHINGRULE = 32;
    public static final int MODE_SYNTAX = 40;
    protected int mode;

    public OpenSchemaBrowserAction() {
        this.mode = 0;
    }

    public OpenSchemaBrowserAction(int mode) {
        this.mode = mode;
    }

    public void run() {
        if (this.mode == 0) {
            SchemaBrowserManager.setInput(this.getConnection(), null);
        } else if (this.mode == 10) {
            SchemaBrowserManager.setInput(this.getConnection(), (AbstractSchemaDescription)this.getOcd());
        } else if (this.mode == 20) {
            SchemaBrowserManager.setInput(this.getConnection(), (AbstractSchemaDescription)this.getAtd());
        } else if (this.mode == 30) {
            SchemaBrowserManager.setInput(this.getConnection(), (AbstractSchemaDescription)this.getEmrd());
        } else if (this.mode == 31) {
            SchemaBrowserManager.setInput(this.getConnection(), (AbstractSchemaDescription)this.getSmrd());
        } else if (this.mode == 32) {
            SchemaBrowserManager.setInput(this.getConnection(), (AbstractSchemaDescription)this.getOmrd());
        } else if (this.mode == 40) {
            SchemaBrowserManager.setInput(this.getConnection(), (AbstractSchemaDescription)this.getLsd());
        } else {
            SchemaBrowserManager.setInput(this.getConnection(), null);
        }
    }

    public String getText() {
        if (this.mode == 0) {
            return Messages.getString("OpenSchemaBrowserAction.OpenSchemaBrowser");
        }
        if (this.mode == 10) {
            return Messages.getString("OpenSchemaBrowserAction.ObjectDescription");
        }
        if (this.mode == 20) {
            return Messages.getString("OpenSchemaBrowserAction.AttributeDescription");
        }
        if (this.mode == 30) {
            return Messages.getString("OpenSchemaBrowserAction.EqualityDescription");
        }
        if (this.mode == 31) {
            return Messages.getString("OpenSchemaBrowserAction.SubstringDescription");
        }
        if (this.mode == 32) {
            return Messages.getString("OpenSchemaBrowserAction.OrderingDescription");
        }
        if (this.mode == 40) {
            return Messages.getString("OpenSchemaBrowserAction.SyntaxDescription");
        }
        return Messages.getString("OpenSchemaBrowserAction.OpenSchemaBrowser");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.mode == 0) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/browser_schemabrowsereditor.gif");
        }
        if (this.mode == 10) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/ocd.png");
        }
        if (this.mode == 20) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/atd.png");
        }
        if (this.mode == 30) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/mrd_equality.png");
        }
        if (this.mode == 31) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/mrd_substring.png");
        }
        if (this.mode == 32) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/mrd_ordering.png");
        }
        if (this.mode == 40) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/lsd.png");
        }
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/browser_schemabrowsereditor.gif");
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        if (this.mode == 0) {
            return this.getConnection() != null;
        }
        if (this.mode == 10) {
            return this.getOcd() != null;
        }
        if (this.mode == 20) {
            return this.getAtd() != null;
        }
        if (this.mode == 30) {
            return this.getEmrd() != null;
        }
        if (this.mode == 31) {
            return this.getSmrd() != null;
        }
        if (this.mode == 32) {
            return this.getOmrd() != null;
        }
        if (this.mode == 40) {
            return this.getLsd() != null;
        }
        return false;
    }

    private LdapSyntaxDescription getLsd() {
        if (this.getConnection() != null) {
            Schema schema = this.getConnection().getSchema();
            AttributeTypeDescription atd = this.getAtd();
            if (atd != null && SchemaUtils.getSyntaxNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema) != null && schema.hasLdapSyntaxDescription(SchemaUtils.getSyntaxNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema))) {
                return schema.getLdapSyntaxDescription(SchemaUtils.getSyntaxNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema));
            }
        }
        return null;
    }

    private ObjectClassDescription getOcd() {
        String ocdName;
        if (this.getSelectedAttributes().length == 0 && this.getSelectedValues().length == 1 && this.getSelectedValues()[0].getAttribute().isObjectClassAttribute() && (ocdName = this.getSelectedValues()[0].getStringValue()) != null && this.getSelectedValues()[0].getAttribute().getEntry().getBrowserConnection().getSchema().hasObjectClassDescription(ocdName)) {
            return this.getSelectedValues()[0].getAttribute().getEntry().getBrowserConnection().getSchema().getObjectClassDescription(ocdName);
        }
        return null;
    }

    private AttributeTypeDescription getAtd() {
        if (this.getSelectedValues().length + this.getSelectedAttributes().length + this.getSelectedAttributeHierarchies().length == 1) {
            AttributeTypeDescription atd = null;
            if (this.getSelectedValues().length == 1) {
                atd = this.getSelectedValues()[0].getAttribute().getAttributeTypeDescription();
            } else if (this.getSelectedAttributes().length == 1) {
                atd = this.getSelectedAttributes()[0].getAttributeTypeDescription();
            } else if (this.getSelectedAttributeHierarchies().length == 1 && this.getSelectedAttributeHierarchies()[0].size() == 1) {
                atd = this.getSelectedAttributeHierarchies()[0].getAttribute().getAttributeTypeDescription();
            }
            return atd;
        }
        return null;
    }

    private IBrowserConnection getConnection() {
        if (this.getSelectedValues().length + this.getSelectedAttributes().length + this.getSelectedAttributeHierarchies().length == 1) {
            IBrowserConnection connection = null;
            if (this.getSelectedValues().length == 1) {
                connection = this.getSelectedValues()[0].getAttribute().getEntry().getBrowserConnection();
            } else if (this.getSelectedAttributes().length == 1) {
                connection = this.getSelectedAttributes()[0].getEntry().getBrowserConnection();
            } else if (this.getSelectedAttributeHierarchies().length == 1 && this.getSelectedAttributeHierarchies()[0].size() == 1) {
                connection = this.getSelectedAttributeHierarchies()[0].getAttribute().getEntry().getBrowserConnection();
            }
            return connection;
        }
        if (this.getSelectedConnections().length == 1) {
            Connection connection = this.getSelectedConnections()[0];
            IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
            return browserConnection;
        }
        if (this.getSelectedEntries().length == 1) {
            return this.getSelectedEntries()[0].getBrowserConnection();
        }
        if (this.getSelectedSearchResults().length == 1) {
            return this.getSelectedSearchResults()[0].getEntry().getBrowserConnection();
        }
        if (this.getSelectedBookmarks().length == 1) {
            return this.getSelectedBookmarks()[0].getBrowserConnection();
        }
        if (this.getSelectedSearches().length == 1) {
            return this.getSelectedSearches()[0].getBrowserConnection();
        }
        return null;
    }

    private MatchingRuleDescription getEmrd() {
        if (this.getConnection() != null) {
            Schema schema = this.getConnection().getSchema();
            AttributeTypeDescription atd = this.getAtd();
            if (atd != null && SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema) != null && schema.hasLdapSyntaxDescription(SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema))) {
                return schema.getMatchingRuleDescription(SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema));
            }
        }
        return null;
    }

    private MatchingRuleDescription getSmrd() {
        if (this.getConnection() != null) {
            Schema schema = this.getConnection().getSchema();
            AttributeTypeDescription atd = this.getAtd();
            if (atd != null && SchemaUtils.getSubstringMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema) != null && schema.hasLdapSyntaxDescription(SchemaUtils.getSubstringMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema))) {
                return schema.getMatchingRuleDescription(SchemaUtils.getSubstringMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema));
            }
        }
        return null;
    }

    private MatchingRuleDescription getOmrd() {
        if (this.getConnection() != null) {
            Schema schema = this.getConnection().getSchema();
            AttributeTypeDescription atd = this.getAtd();
            if (atd != null && SchemaUtils.getOrderingMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema) != null && schema.hasLdapSyntaxDescription(SchemaUtils.getOrderingMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema))) {
                return schema.getMatchingRuleDescription(SchemaUtils.getOrderingMatchingRuleNameOrNumericOidTransitive((AttributeTypeDescription)atd, (Schema)schema));
            }
        }
        return null;
    }
}

