/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import java.util.LinkedHashSet;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.dialogs.MoveEntriesDialog;
import org.apache.directory.studio.ldapbrowser.common.dialogs.SimulateRenameDialogImpl;
import org.apache.directory.studio.ldapbrowser.core.jobs.MoveEntriesJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SimulateRenameDialog;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.impl.RootDSE;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;

public class MoveAction
extends BrowserAction {
    public String getText() {
        IEntry[] entries = this.getEntries();
        ISearch[] searches = this.getSearches();
        IBookmark[] bookmarks = this.getBookmarks();
        if (entries.length > 0 && searches.length == 0 && bookmarks.length == 0) {
            return entries.length == 1 ? Messages.getString("MoveAction.MoveEntry") : Messages.getString("MoveAction.MoveEntries");
        }
        return Messages.getString("MoveAction.Move");
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getCommandId() {
        return "org.eclipse.ui.edit.move";
    }

    public void run() {
        IEntry[] entries = this.getEntries();
        ISearch[] searches = this.getSearches();
        IBookmark[] bookmarks = this.getBookmarks();
        if (entries.length > 0 && searches.length == 0 && bookmarks.length == 0) {
            this.moveEntries(entries);
        }
    }

    public boolean isEnabled() {
        try {
            IEntry[] entries = this.getEntries();
            ISearch[] searches = this.getSearches();
            IBookmark[] bookmarks = this.getBookmarks();
            return entries.length > 0 && searches.length == 0 && bookmarks.length == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected IEntry[] getEntries() {
        if (this.getSelectedBookmarks().length + this.getSelectedSearches().length + this.getSelectedAttributes().length + this.getSelectedValues().length == 0 && this.getSelectedEntries().length + this.getSelectedSearchResults().length > 0) {
            int i;
            LinkedHashSet<IEntry> entriesSet = new LinkedHashSet<IEntry>();
            for (i = 0; i < this.getSelectedEntries().length; ++i) {
                entriesSet.add(this.getSelectedEntries()[i]);
            }
            for (i = 0; i < this.getSelectedSearchResults().length; ++i) {
                entriesSet.add(this.getSelectedSearchResults()[i].getEntry());
            }
            IEntry[] entries = entriesSet.toArray(new IEntry[entriesSet.size()]);
            for (int i2 = 0; i2 < entries.length; ++i2) {
                if (entries[i2] != null && !(entries[i2] instanceof RootDSE)) continue;
                return new IEntry[0];
            }
            return entries;
        }
        return new IEntry[0];
    }

    protected void moveEntries(IEntry[] entries) {
        LdapDN newParentDn;
        MoveEntriesDialog moveDialog = new MoveEntriesDialog(this.getShell(), entries);
        if (moveDialog.open() == 0 && (newParentDn = moveDialog.getParentDn()) != null) {
            IEntry newParentEntry = entries[0].getBrowserConnection().getEntryFromCache(newParentDn);
            if (newParentEntry == null) {
                ReadEntryRunnable runnable = new ReadEntryRunnable(entries[0].getBrowserConnection(), newParentDn);
                RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, null, (boolean)true);
                newParentEntry = runnable.getReadEntry();
            }
            if (newParentEntry != null) {
                new MoveEntriesJob(entries, newParentEntry, (SimulateRenameDialog)new SimulateRenameDialogImpl(this.getShell())).execute();
            }
        }
    }

    protected ISearch[] getSearches() {
        if (this.getSelectedSearches().length == 1) {
            return this.getSelectedSearches();
        }
        return new ISearch[0];
    }

    protected IBookmark[] getBookmarks() {
        if (this.getSelectedBookmarks().length == 1) {
            return this.getSelectedBookmarks();
        }
        return new IBookmark[0];
    }
}

