/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class LocateInDitAction
extends BrowserAction {
    public final void run() {
        ConnectionAndDn connectionAndDn = this.getConnectionAndDn();
        if (connectionAndDn != null) {
            LdapDN dn;
            IBrowserConnection connection = connectionAndDn.connection;
            IEntry entry = connection.getEntryFromCache(dn = connectionAndDn.dn);
            if (entry == null) {
                ReadEntryRunnable runnable = new ReadEntryRunnable(connection, dn);
                RunnableContextRunner.execute((StudioRunnableWithProgress)runnable, null, (boolean)true);
                entry = runnable.getReadEntry();
            }
            if (entry != null) {
                String targetId = BrowserView.getId();
                IViewPart targetView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(targetId);
                if (targetView == null) {
                    try {
                        targetView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(targetId, null, 1);
                    }
                    catch (PartInitException e) {
                        // empty catch block
                    }
                }
                if (targetView != null && targetView instanceof BrowserView) {
                    ((BrowserView)targetView).select(entry);
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)targetView);
                }
            }
        }
    }

    public String getCommandId() {
        return BrowserUIConstants.CMD_LOCATE_IN_DIT;
    }

    public boolean isEnabled() {
        return this.getConnectionAndDn() != null;
    }

    protected abstract ConnectionAndDn getConnectionAndDn();

    protected class ConnectionAndDn {
        private IBrowserConnection connection;
        private LdapDN dn;

        protected ConnectionAndDn(IBrowserConnection connection, LdapDN dn) {
            this.connection = connection;
            this.dn = dn;
        }
    }
}

