/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.LocateInDitAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;

public class LocateDnInDitAction
extends LocateInDitAction {
    public String getText() {
        return Messages.getString("LocateDnInDitAction.LocateDN");
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/locate_dn_in_dit.gif");
    }

    protected LocateInDitAction.ConnectionAndDn getConnectionAndDn() {
        IValue value;
        if (this.getSelectedAttributeHierarchies().length == 1 && this.getSelectedAttributeHierarchies()[0].getAttribute().getValueSize() == 1 && this.getSelectedSearchResults().length == 1) {
            try {
                value = this.getSelectedAttributeHierarchies()[0].getAttribute().getValues()[0];
                if (value.isString() && LdapDN.isValid((String)value.getStringValue())) {
                    return new LocateInDitAction.ConnectionAndDn(this, value.getAttribute().getEntry().getBrowserConnection(), new LdapDN(value.getStringValue()));
                }
            }
            catch (InvalidNameException e) {
                // empty catch block
            }
        }
        if (this.getSelectedValues().length == 1 && this.getSelectedAttributes().length == 0) {
            try {
                value = this.getSelectedValues()[0];
                if (value.isString() && LdapDN.isValid((String)value.getStringValue())) {
                    return new LocateInDitAction.ConnectionAndDn(this, value.getAttribute().getEntry().getBrowserConnection(), new LdapDN(value.getStringValue()));
                }
            }
            catch (InvalidNameException e) {
                // empty catch block
            }
        }
        if (this.getSelectedSearchResults().length == 1 && this.getSelectedAttributeHierarchies().length == 0) {
            ISearchResult result = this.getSelectedSearchResults()[0];
            return new LocateInDitAction.ConnectionAndDn(this, result.getEntry().getBrowserConnection(), result.getEntry().getDn());
        }
        return null;
    }
}

