/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportCsvWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportDsmlWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportExcelWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportLdifWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportOdfWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ImportDsmlWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ImportLdifWizard;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;

public class ImportExportAction
extends BrowserAction {
    public static final int TYPE_IMPORT_LDIF = 0;
    public static final int TYPE_EXPORT_LDIF = 1;
    public static final int TYPE_EXPORT_CSV = 2;
    public static final int TYPE_EXPORT_EXCEL = 3;
    public static final int TYPE_IMPORT_DSML = 4;
    public static final int TYPE_EXPORT_DSML = 5;
    public static final int TYPE_EXPORT_ODF = 6;
    private int type;

    public ImportExportAction(int type) {
        this.type = type;
    }

    public String getText() {
        if (this.type == 0) {
            return Messages.getString("ImportExportAction.LDIFImport");
        }
        if (this.type == 1) {
            return Messages.getString("ImportExportAction.LDIFExport");
        }
        if (this.type == 2) {
            return Messages.getString("ImportExportAction.CVSExport");
        }
        if (this.type == 3) {
            return Messages.getString("ImportExportAction.ExcelExport");
        }
        if (this.type == 6) {
            return Messages.getString("ImportExportAction.OdfExport");
        }
        if (this.type == 4) {
            return Messages.getString("ImportExportAction.DSMLImport");
        }
        if (this.type == 5) {
            return Messages.getString("ImportExportAction.DSMLExport");
        }
        return Messages.getString("ImportExportAction.Export");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.type == 0) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/import_ldif.gif");
        }
        if (this.type == 1) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/export_ldif.gif");
        }
        if (this.type == 2) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/export_csv.gif");
        }
        if (this.type == 3) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/export_xls.gif");
        }
        if (this.type == 6) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/export_odf.gif");
        }
        if (this.type == 4) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/import_dsml.gif");
        }
        if (this.type == 5) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/export_dsml.gif");
        }
        return null;
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        return this.getEntry() != null || this.getConnection() != null || this.getSearch() != null || this.getConnectionInput() != null;
    }

    public void run() {
        Wizard wizard = null;
        if (this.type == 0) {
            if (this.getEntry() != null) {
                wizard = new ImportLdifWizard(this.getEntry().getBrowserConnection());
            } else if (this.getSearch() != null) {
                wizard = new ImportLdifWizard(this.getSearch().getBrowserConnection());
            } else if (this.getConnectionInput() != null) {
                wizard = new ImportLdifWizard(this.getConnectionInput());
            } else if (this.getConnection() != null) {
                wizard = new ImportLdifWizard(this.getConnection());
            }
        } else if (this.type == 4) {
            if (this.getEntry() != null) {
                wizard = new ImportDsmlWizard(this.getEntry().getBrowserConnection());
            } else if (this.getSearch() != null) {
                wizard = new ImportDsmlWizard(this.getSearch().getBrowserConnection());
            } else if (this.getConnectionInput() != null) {
                wizard = new ImportDsmlWizard(this.getConnectionInput());
            } else if (this.getConnection() != null) {
                wizard = new ImportDsmlWizard(this.getConnection());
            }
        } else if (this.type == 1) {
            wizard = new ExportLdifWizard();
        } else if (this.type == 2) {
            wizard = new ExportCsvWizard();
        } else if (this.type == 3) {
            wizard = new ExportExcelWizard();
        } else if (this.type == 6) {
            wizard = new ExportOdfWizard();
        } else if (this.type == 5) {
            wizard = new ExportDsmlWizard();
        }
        if (wizard != null) {
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.setBlockOnOpen(true);
            dialog.create();
            dialog.open();
        }
    }

    protected IEntry getEntry() {
        IEntry entry = null;
        if (this.getSelectedEntries().length > 0) {
            entry = this.getSelectedEntries()[0];
        } else if (this.getSelectedSearchResults().length > 0) {
            entry = this.getSelectedSearchResults()[0].getEntry();
        } else if (this.getSelectedBookmarks().length > 0) {
            entry = this.getSelectedBookmarks()[0].getEntry();
        }
        return entry != null ? entry : null;
    }

    protected IBrowserConnection getConnection() {
        if (this.getSelectedConnections().length > 0 && this.getSelectedConnections()[0].getJNDIConnectionWrapper().isConnected()) {
            Connection connection = this.getSelectedConnections()[0];
            IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
            return browserConnection;
        }
        return null;
    }

    protected ISearch getSearch() {
        return this.getSelectedSearches().length > 0 ? this.getSelectedSearches()[0] : null;
    }

    protected IBrowserConnection getConnectionInput() {
        if (this.getInput() != null && this.getInput() instanceof IBrowserConnection) {
            return (IBrowserConnection)this.getInput();
        }
        return null;
    }
}

