/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.CopyAction;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyValueAction
extends BrowserAction {
    private Mode mode;
    private ValueEditorManager valueEditorManager;

    public CopyValueAction(Mode mode, ValueEditorManager valueEditorManager) {
        this.mode = mode;
        this.valueEditorManager = valueEditorManager;
    }

    public String getText() {
        switch (this.mode) {
            case UTF8: {
                return this.getValueSet().size() > 1 ? Messages.getString("CopyValueAction.CopyValuesUTF") : Messages.getString("CopyValueAction.CopyValueUTF");
            }
            case BASE64: {
                return this.getValueSet().size() > 1 ? Messages.getString("CopyValueAction.CopyValuesBase") : Messages.getString("CopyValueAction.CopyValueBase");
            }
            case HEX: {
                return this.getValueSet().size() > 1 ? Messages.getString("CopyValueAction.VopyValuesHex") : Messages.getString("CopyValueAction.CopyValueHex");
            }
            case LDIF: {
                return this.getValueSet().size() > 1 ? Messages.getString("CopyValueAction.CopyValuePairs") : Messages.getString("CopyValueAction.CopyValuePair");
            }
            case DISPLAY: {
                return this.getValueSet().size() > 1 ? Messages.getString("CopyValueAction.CopyDisplayValues") : Messages.getString("CopyValueAction.CopyDisplayValue");
            }
        }
        return Messages.getString("CopyValueAction.CopyValue");
    }

    public ImageDescriptor getImageDescriptor() {
        switch (this.mode) {
            case UTF8: {
                return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_raw.gif");
            }
            case BASE64: {
                return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_base64.gif");
            }
            case HEX: {
                return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_hex.gif");
            }
            case LDIF: {
                return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_ldif.gif");
            }
            case DISPLAY: {
                return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_display.gif");
            }
        }
        return null;
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        return this.getValueSet().size() > 0 || this.getSelectedSearchResults().length > 0;
    }

    public void run() {
        StringBuffer text = new StringBuffer();
        Set<IValue> valueSet = this.getValueSet();
        if (!valueSet.isEmpty()) {
            Iterator<IValue> iterator = valueSet.iterator();
            while (iterator.hasNext()) {
                IValue value = iterator.next();
                switch (this.mode) {
                    case UTF8: {
                        text.append(LdifUtils.utf8decode((byte[])value.getBinaryValue()));
                        if (!iterator.hasNext()) break;
                        text.append(BrowserCoreConstants.LINE_SEPARATOR);
                        break;
                    }
                    case BASE64: {
                        text.append(LdifUtils.base64encode((byte[])value.getBinaryValue()));
                        if (!iterator.hasNext()) break;
                        text.append(BrowserCoreConstants.LINE_SEPARATOR);
                        break;
                    }
                    case HEX: {
                        text.append(LdifUtils.hexEncode((byte[])value.getBinaryValue()));
                        if (!iterator.hasNext()) break;
                        text.append(BrowserCoreConstants.LINE_SEPARATOR);
                        break;
                    }
                    case LDIF: {
                        text.append(ModelConverter.valueToLdifAttrValLine((IValue)value).toFormattedString(Utils.getLdifFormatParameters()));
                        break;
                    }
                    case DISPLAY: {
                        IValueEditor ve = this.valueEditorManager.getCurrentValueEditor(value);
                        String displayValue = ve.getDisplayValue(value);
                        text.append(displayValue);
                        if (!iterator.hasNext()) break;
                        text.append(BrowserCoreConstants.LINE_SEPARATOR);
                    }
                }
            }
        } else if (this.getSelectedSearchResults().length > 0) {
            LdapDN dn = this.getSelectedSearchResults()[0].getDn();
            switch (this.mode) {
                case UTF8: 
                case DISPLAY: {
                    text.append(dn.getUpName());
                    break;
                }
                case BASE64: {
                    text.append(LdifUtils.base64encode((byte[])LdifUtils.utf8encode((String)dn.getUpName())));
                    break;
                }
                case HEX: {
                    text.append(LdifUtils.hexEncode((byte[])LdifUtils.utf8encode((String)dn.getUpName())));
                    break;
                }
                case LDIF: {
                    text.append(ModelConverter.dnToLdifDnLine((LdapDN)dn).toFormattedString(Utils.getLdifFormatParameters()));
                }
            }
        }
        if (text.length() > 0) {
            CopyAction.copyToClipboard((Object[])new Object[]{text.toString()}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
        }
    }

    protected Set<IValue> getValueSet() {
        LinkedHashSet<IValue> valueSet = new LinkedHashSet<IValue>();
        for (AttributeHierarchy attributeHierarchy : this.getSelectedAttributeHierarchies()) {
            for (IAttribute att : attributeHierarchy) {
                valueSet.addAll(Arrays.asList(att.getValues()));
            }
        }
        for (AttributeHierarchy attributeHierarchy : this.getSelectedAttributes()) {
            valueSet.addAll(Arrays.asList(attributeHierarchy.getValues()));
        }
        valueSet.addAll(Arrays.asList(this.getSelectedValues()));
        return valueSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        UTF8,
        BASE64,
        HEX,
        LDIF,
        DISPLAY;

    }
}

