/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.CopyAction;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyUrlAction
extends BrowserAction {
    public void run() {
        LdapURL url = null;
        if (this.getSelectedSearches().length > 0) {
            url = this.getSelectedSearches()[0].getUrl();
        } else if (this.getSelectedEntries().length > 0) {
            url = this.getSelectedEntries()[0].getUrl();
        } else if (this.getSelectedAttributes().length > 0) {
            url = this.getSelectedAttributes()[0].getEntry().getUrl();
        } else if (this.getSelectedAttributeHierarchies().length > 0) {
            url = this.getSelectedAttributeHierarchies()[0].getAttribute().getEntry().getUrl();
        } else if (this.getSelectedValues().length > 0) {
            url = this.getSelectedValues()[0].getAttribute().getEntry().getUrl();
        } else if (this.getSelectedSearchResults().length > 0) {
            url = this.getSelectedSearchResults()[0].getEntry().getUrl();
        } else if (this.getSelectedBookmarks().length > 0) {
            url = this.getSelectedBookmarks()[0].getEntry().getUrl();
        }
        if (url != null) {
            CopyAction.copyToClipboard((Object[])new Object[]{url.toString()}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public String getText() {
        return Messages.getString("CopyUrlAction.CopyURL");
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_url.gif");
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        return this.getSelectedSearches().length + this.getSelectedEntries().length + this.getSelectedSearchResults().length + this.getSelectedBookmarks().length == 1 || this.getSelectedAttributes().length + this.getSelectedValues().length > 0;
    }
}

